#!/bin/bash

# 指定完整路径
QMCMD="/usr/sbin/qm"
LOGFILE="/Snapshot/Snapshot.log"

date=$(date +%Y%m%d)
rmdate=$(date -d "3 days ago" +%Y%m%d)

# 创建当天的快照，ID=100
$QMCMD snapshot 100 z$date

# 等待10秒
sleep 10

# 删除三天前的快照，ID=100
$QMCMD delsnapshot 100 z$rmdate

# 记录执行结果到日志文件（追加而不是覆盖）
echo "$(date): Script executed successfully" >> $LOGFILE