/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein;

import com.oracle.outsidein.Exporter;
import com.oracle.outsidein.ExporterImpl;
import com.oracle.outsidein.OutsideInConfig;
import com.oracle.outsidein.OutsideInException;
import com.oracle.outsidein.OutsideInVersion;
import java.io.File;
import java.io.IOException;
import net.bitform.oilink.OILink;
import net.bitform.oilink.OILinkStatus;

public class OutsideIn {
    private static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");

    private OutsideIn() {
    }

    public static Exporter newLocalExporter() throws OutsideInException {
        OILinkStatus oILinkStatus = OILink.init();
        if (!oILinkStatus.isAvailable()) {
            throw new OutsideInException(oILinkStatus.getProblem());
        }
        return new ExporterImpl();
    }

    public static Exporter newLocalExporter(int n) throws OutsideInException {
        OILinkStatus oILinkStatus = OILink.init(null, n);
        if (!oILinkStatus.isAvailable()) {
            throw new OutsideInException(oILinkStatus.getProblem());
        }
        return new ExporterImpl();
    }

    public static Exporter newLocalExporter(String string) throws OutsideInException {
        if (isWindows) {
            throw new OutsideInException("Running oilink as a different user is only supported on unix platforms");
        }
        OILinkStatus oILinkStatus = OILink.init();
        if (!oILinkStatus.isAvailable()) {
            throw new OutsideInException(oILinkStatus.getProblem());
        }
        return new ExporterImpl(string, null);
    }

    public static Exporter newLocalExporter(Exporter exporter) throws OutsideInException {
        OILinkStatus oILinkStatus = OILink.init();
        if (!oILinkStatus.isAvailable()) {
            throw new OutsideInException(oILinkStatus.getProblem());
        }
        return new ExporterImpl(exporter);
    }

    public static OutsideInVersion getCoreVersion() {
        OILinkStatus oILinkStatus = OILink.init();
        if (!oILinkStatus.isAvailable()) {
            return null;
        }
        return new OutsideInVersion(oILinkStatus.getVersionInfo());
    }

    public static void setLocation(File file) throws OutsideInException {
        OutsideInConfig outsideInConfig = new OutsideInConfig();
        outsideInConfig.setLocation(file);
        OutsideIn.init(outsideInConfig);
    }

    public static void setConfiguration(OutsideInConfig outsideInConfig) throws OutsideInException {
        OutsideIn.init(outsideInConfig);
    }

    private static void init(OutsideInConfig outsideInConfig) throws OutsideInException {
        OILinkStatus oILinkStatus;
        OILinkStatus oILinkStatus2 = OILink.getStatus();
        if (oILinkStatus2 != null && oILinkStatus2.isAvailable()) {
            throw new OutsideInException("The location has already been set.");
        }
        File file = outsideInConfig.getLocation();
        String string = null;
        if (file != null) {
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            if (!file.exists() || !file.isDirectory()) {
                throw new IllegalArgumentException("The directory (" + string + ") does not exist.");
            }
        }
        if (!(oILinkStatus = OILink.init(string, outsideInConfig.getOILinkProcessResetCount())).isAvailable()) {
            throw new OutsideInException(oILinkStatus.getProblem());
        }
    }
}

