/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein;

import com.oracle.outsidein.FileFormat;
import java.util.EnumSet;
import net.bitform.oilink.OILinkMessages;

public class ObjectInfo {
    private String m_name;
    private FileFormat m_fileId;
    private EnumSet<ObjectInfoFlagValues> m_flags;
    private CompressionValue m_compression;

    public String getName() {
        return this.m_name;
    }

    public FileFormat getFormatId() {
        return this.m_fileId;
    }

    public EnumSet<ObjectInfoFlagValues> getFlags() {
        return this.m_flags;
    }

    public CompressionValue getCompression() {
        return this.m_compression;
    }

    ObjectInfo(OILinkMessages.DAGetObjectInfoResponse dAGetObjectInfoResponse) {
        this.m_name = dAGetObjectInfoResponse.getName();
        this.m_fileId = FileFormat.forId(dAGetObjectInfoResponse.getFiId());
        this.m_flags = ObjectInfoFlagValues.forValue(dAGetObjectInfoResponse.getFlags());
        this.m_compression = CompressionValue.forValue(dAGetObjectInfoResponse.getCompressionType());
    }

    public static enum CompressionValue {
        NONE(0L),
        ZLIB(1L),
        BASE64(2L),
        LZSS(3L),
        ASCII85(4L),
        ASCIIHEX(5L),
        RLE(6L),
        FLATE(7L),
        LZW(8L),
        DCT(9L),
        CCITT(11L),
        RC4(13L),
        PKMPLOD(10L),
        MIFASCIIDECODE(12L),
        ZLIB_NOHEADER(14L),
        UUENCODED(15L),
        XXENCODED(16L),
        BINHEX(17L),
        YENC(18L),
        BTOA(19L),
        QUOTEDPRINTABLE(20L),
        UTF7(21L),
        COMPRESSEDRTF(22L),
        JBIG2(23L),
        MSZIP(24L),
        LZX(25L),
        AES128(26L),
        AES192(27L),
        AES256(28L),
        ZIPCRYPTO(29L),
        JPXDECODE(30L),
        DEFLATE64(31L),
        ZIPREDUCE(32L),
        ZIPSHRINK(33L),
        UNKNOWN(255L);

        final long value;

        private CompressionValue(long l) {
            this.value = l;
        }

        public static CompressionValue forValue(long l) {
            for (CompressionValue compressionValue : CompressionValue.values()) {
                if (compressionValue.value != l) continue;
                return compressionValue;
            }
            return UNKNOWN;
        }
    }

    public static enum ObjectInfoFlagValues {
        PARTIALFILE(1L),
        PROTECTEDFILE(2L),
        UNSUPPORTEDCOMP(4L),
        DRMFILE(8L),
        UNIDENTIFIEDFILE(16L),
        LINKTOFILE(32L),
        ARCKNOWNENCRYPT(64L);

        final long value;

        private ObjectInfoFlagValues(long l) {
            this.value = l;
        }

        static EnumSet<ObjectInfoFlagValues> forValue(long l) {
            EnumSet<ObjectInfoFlagValues> enumSet = EnumSet.noneOf(ObjectInfoFlagValues.class);
            for (ObjectInfoFlagValues objectInfoFlagValues : ObjectInfoFlagValues.values()) {
                if (0L == (objectInfoFlagValues.value & l)) continue;
                enumSet.add(objectInfoFlagValues);
            }
            return enumSet;
        }
    }
}

