/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein.options;

import com.oracle.outsidein.OutsideInException;
import com.oracle.outsidein.SeekableByteChannel6;
import com.oracle.outsidein.SeekableByteChannel6ToBasicIO;
import java.io.File;
import java.io.IOException;
import net.bitform.oilink.BasicIO;
import net.bitform.oilink.FileToBasicIO;

public class Watermark {
    private final int SCCOPT_GRAPHIC_WATERMARK_VERTICAL_OFFSETFROM_CENTER = 0;
    private final int SCCOPT_GRAPHIC_WATERMARK_VERTICAL_OFFSETFROM_TOP = 1;
    private final int SCCOPT_GRAPHIC_WATERMARK_VERTICAL_OFFSETFROM_BOTTOM = 2;
    private final int SCCOPT_GRAPHIC_WATERMARK_HORIZONTAL_OFFSETFROM_CENTER = 0;
    private final int SCCOPT_GRAPHIC_WATERMARK_HORIZONTAL_OFFSETFROM_LEFT = 1;
    private final int SCCOPT_GRAPHIC_WATERMARK_HORIZONTAL_OFFSETFROM_RIGHT = 2;
    boolean m_bEnabled = false;
    private int m_Opacity = 50;
    private ScaleModeValue m_Scalemode = ScaleModeValue.NOSCALING;
    private int m_Percent = 100;
    private BasicIO m_BasicIO = null;
    private AnchorPosition m_AnchorPosition = AnchorPosition.CENTERCENTER;
    private int m_VertOffset = 0;
    private int m_HorzOffset = 0;

    public int getOpacity() {
        return this.m_Opacity;
    }

    public void setOpacity(int n) throws OutsideInException {
        if (0 < n && n < 256) {
            this.m_Opacity = n;
        } else if (0 == n) {
            this.m_bEnabled = false;
        } else {
            throw new IllegalArgumentException("Opacity value is out of range");
        }
    }

    ScaleModeValue getScalemode() {
        return this.m_Scalemode;
    }

    void setScalemode(ScaleModeValue scaleModeValue) {
        this.m_Scalemode = scaleModeValue;
    }

    public int getPercent() {
        return this.m_Percent;
    }

    public void setPercent(int n) {
        if (n < 0 || 100 < n) {
            throw new IllegalArgumentException("Percent value is out of range");
        }
        this.m_Percent = n;
        this.m_Scalemode = 0 == this.m_Percent ? ScaleModeValue.NOSCALING : ScaleModeValue.PERCENT;
    }

    BasicIO getBasicIO() {
        return this.m_BasicIO;
    }

    public AnchorPosition getAnchorPosition() {
        return this.m_AnchorPosition;
    }

    public void setAnchorPosition(AnchorPosition anchorPosition) {
        this.m_AnchorPosition = anchorPosition;
    }

    int getVertAnchorPosition() {
        switch (this.m_AnchorPosition) {
            case TOPLEFT: 
            case TOPCENTER: 
            case TOPRIGHT: {
                return 1;
            }
            case CENTERLEFT: 
            case CENTERCENTER: 
            case CENTERRIGHT: {
                return 0;
            }
            case BOTTOMLEFT: 
            case BOTTOMCENTER: 
            case BOTTOMRIGHT: {
                return 2;
            }
        }
        return 0;
    }

    int getHorzAnchorPosition() {
        switch (this.m_AnchorPosition) {
            case TOPLEFT: 
            case CENTERLEFT: 
            case BOTTOMLEFT: {
                return 1;
            }
            case TOPCENTER: 
            case CENTERCENTER: 
            case BOTTOMCENTER: {
                return 0;
            }
            case TOPRIGHT: 
            case CENTERRIGHT: 
            case BOTTOMRIGHT: {
                return 2;
            }
        }
        return 0;
    }

    public int getVertOffset() {
        return this.m_VertOffset;
    }

    public void setVertOffset(int n) {
        if (n < -100 || 100 < n) {
            throw new IllegalArgumentException("Vertical offset value is out of range");
        }
        this.m_VertOffset = n;
    }

    public int getHorzOffset() {
        return this.m_HorzOffset;
    }

    public void setHorzOffset(int n) {
        if (n < -100 || 100 < n) {
            throw new IllegalArgumentException("Horizontal offset value is out of range");
        }
        this.m_HorzOffset = n;
    }

    public Watermark() {
        this.m_bEnabled = false;
    }

    public Watermark(File file) throws OutsideInException {
        this.m_bEnabled = true;
        try {
            this.m_BasicIO = new FileToBasicIO(file, false);
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException);
        }
    }

    public Watermark(SeekableByteChannel6 seekableByteChannel6) throws OutsideInException {
        this.m_bEnabled = true;
        this.m_BasicIO = new SeekableByteChannel6ToBasicIO(seekableByteChannel6);
    }

    public Watermark(File file, int n, int n2, AnchorPosition anchorPosition, int n3, int n4) throws OutsideInException {
        this.m_bEnabled = true;
        try {
            this.m_BasicIO = new FileToBasicIO(file, false);
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException);
        }
        this.setOpacity(n);
        this.setPercent(n2);
        this.setAnchorPosition(anchorPosition);
        this.setVertOffset(n3);
        this.setHorzOffset(n4);
    }

    public Watermark(SeekableByteChannel6 seekableByteChannel6, int n, int n2, AnchorPosition anchorPosition, int n3, int n4) throws OutsideInException {
        this.m_bEnabled = true;
        this.m_BasicIO = new SeekableByteChannel6ToBasicIO(seekableByteChannel6);
        this.setOpacity(n);
        this.setPercent(n2);
        this.setAnchorPosition(anchorPosition);
        this.setVertOffset(n3);
    }

    public static enum AnchorPosition {
        TOPLEFT,
        TOPCENTER,
        TOPRIGHT,
        CENTERLEFT,
        CENTERCENTER,
        CENTERRIGHT,
        BOTTOMLEFT,
        BOTTOMCENTER,
        BOTTOMRIGHT;

    }

    public static enum ScaleModeValue {
        NOSCALING(0L),
        PERCENT(1L),
        FITTOPAGE(2L);

        final long value;

        private ScaleModeValue(long l) {
            this.value = l;
        }
    }
}

