/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein.options;

import com.google.protobuf.GeneratedMessageLite;
import com.oracle.outsidein.Callback;
import com.oracle.outsidein.ColorInfo;
import com.oracle.outsidein.FileFormat;
import com.oracle.outsidein.OutsideInException;
import com.oracle.outsidein.SeekableByteChannel6;
import com.oracle.outsidein.SeekableByteChannel6ToBasicIO;
import com.oracle.outsidein.annotations.RedactAnnotation;
import com.oracle.outsidein.options.FontAliases;
import com.oracle.outsidein.options.FontInfo;
import com.oracle.outsidein.options.FontList;
import com.oracle.outsidein.options.GridWrapInfo;
import com.oracle.outsidein.options.MailHeaders;
import com.oracle.outsidein.options.MarginText;
import com.oracle.outsidein.options.Margins;
import com.oracle.outsidein.options.OptionImpl;
import com.oracle.outsidein.options.Options;
import com.oracle.outsidein.options.OptionsCache;
import com.oracle.outsidein.options.PageInfo;
import com.oracle.outsidein.options.PageRange;
import com.oracle.outsidein.options.Watermark;
import com.oracle.outsidein.options.XMLReference;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.bitform.oilink.OIHandle;
import net.bitform.oilink.OILink;
import net.bitform.oilink.OILinkMessages;

public class OptionsCacheImpl
implements OptionsCache {
    static final boolean isWindows = System.getProperty("os.name").startsWith("Windows");
    protected List<SourceFileInfo> m_srcInfoList = new LinkedList<SourceFileInfo>();
    protected SourceFileInfo m_srcInfo = new SourceFileInfo();
    protected SourceFileInfo m_cumulativeInfo = new SourceFileInfo();
    protected File m_dstFile;
    protected SeekableByteChannel6ToBasicIO m_dstRedirect;
    protected FileFormat m_dstFileId;
    protected boolean m_bDoOpenInput = true;
    protected File m_templatefile = null;
    protected boolean bNextFile;
    private boolean m_bProcessingFirstFile = true;

    protected OptionsCacheImpl() {
    }

    protected OptionsCacheImpl(OptionsCacheImpl optionsCacheImpl) {
        this();
        this.m_dstFileId = optionsCacheImpl.m_dstFileId;
        this.m_templatefile = optionsCacheImpl.m_templatefile;
        this.m_srcInfo.inheritSourceFileInfo(optionsCacheImpl.m_cumulativeInfo);
        this.m_cumulativeInfo.inheritSourceFileInfo(optionsCacheImpl.m_cumulativeInfo);
    }

    @Override
    public OptionsCache setProcessCreationTimeout(int n) {
        this.m_srcInfo.m_processCreationTimeout = n;
        this.m_cumulativeInfo.m_processCreationTimeout = n;
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.ProcessCreationTimeoutOption);
        return this;
    }

    protected void setOptions(OILink oILink, OIHandle oIHandle, OptionImpl.OptionScopeValue optionScopeValue) throws OutsideInException {
        for (Options options : this.m_cumulativeInfo.m_optionsCache.keySet()) {
            if (options.getOptionScope() != optionScopeValue) continue;
            try {
                options.setOption(oILink, oIHandle, this.m_cumulativeInfo.m_optionsCache.get(options));
            }
            catch (IOException iOException) {
                throw new OutsideInException("Error setting " + options.getName() + " option", iOException);
            }
        }
        this.setSpecialOptions(oILink, oIHandle, optionScopeValue);
    }

    private void setSpecialOptions(OILink oILink, OIHandle oIHandle, OptionImpl.OptionScopeValue optionScopeValue) throws OutsideInException {
        GeneratedMessageLite.Builder builder2;
        Object iOException;
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.TiffOptions) && Options.TIFFColorSpace.getOptionScope() == optionScopeValue) {
            long l = 0L;
            if (this.getTIFFMultiPage()) {
                l = 1L;
            }
            OILinkMessages.DASetOption.TiffOptions.Builder object3 = OILinkMessages.DASetOption.TiffOptions.newBuilder().setDwColorSpace(this.getTIFFColorSpace().value).setDwCompression(this.getTIFFCompression().value).setDwByteOrder(this.getTIFFByteOrder().value).setDwTIFFFlags(l).setDwFillOrder(this.getTIFFFillOrder().value);
            try {
                oILink.DASetOption(oIHandle, 84, object3.build());
            }
            catch (IOException iOException2) {
                throw new OutsideInException("Error setting Tiff options", iOException2);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.DefaultPageSizeOption) && Options.DefaultPageSize.getOptionScope() == optionScopeValue) {
            iOException = this.getDefaultPageSize();
            builder2 = OILinkMessages.DASetOption.DefaultPageSize.newBuilder().setFHeight(((PageInfo)iOException).getHeight()).setFWidth(((PageInfo)iOException).getWidth()).setWUnits(((PageInfo)iOException).getUnits().value);
            try {
                oILink.DASetOption(oIHandle, 87539, ((OILinkMessages.DASetOption.DefaultPageSize.Builder)builder2).build());
            }
            catch (IOException object) {
                throw new OutsideInException("Error setting DefaultPageSize option", object);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.DefaultPrintMarginOption) && Options.DefaultPageMargins.getOptionScope() == optionScopeValue) {
            iOException = this.getDefaultPageMargins();
            builder2 = OILinkMessages.DASetOption.DefaultPrintMargins.newBuilder().setDwTop(((Margins)iOException).getTop()).setDwBottom(((Margins)iOException).getBottom()).setDwLeft(((Margins)iOException).getLeft()).setDwRight(((Margins)iOException).getRight());
            try {
                oILink.DASetOption(oIHandle, 337782, ((OILinkMessages.DASetOption.DefaultPrintMargins.Builder)builder2).build());
            }
            catch (IOException iOException2) {
                throw new OutsideInException("Error setting DefaultPageMargins option", iOException2);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.DefaultPrintFontOption) && Options.DefaultRenderFont.getOptionScope() == optionScopeValue) {
            iOException = this.getDefaultRenderFont();
            int builder4 = 0;
            for (FontInfo.FontAttributeValues fontAttributeValues : ((FontInfo)iOException).getFontAttrs()) {
                builder4 |= fontAttributeValues.value;
            }
            iOException = OILinkMessages.DASetOption.DefaultPrintFont.newBuilder().setSzFace(((FontInfo)iOException).getFontFace()).setWHeight(((FontInfo)iOException).getHeight()).setWAttr(builder4).setWType(0);
            try {
                oILink.DASetOption(oIHandle, 337783, ((OILinkMessages.DASetOption.DefaultPrintFont.Builder)iOException).build());
            }
            catch (IOException iOException3) {
                throw new OutsideInException("Error setting DefaultPrintFont option", iOException3);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.FontAliasOption) && Options.FontAliasList.getOptionScope() == optionScopeValue) {
            iOException = this.getFontAliasList();
            OILinkMessages.DASetOption.PrintFontAlias.Builder string = OILinkMessages.DASetOption.PrintFontAlias.newBuilder().setIncludeDefaults(false);
            if (iOException != null && ((FontAliases)iOException).getAliasList() != null) {
                for (String string2 : ((FontAliases)iOException).getAliasList().keySet()) {
                    OILinkMessages.DASetOption.FontAlias.Builder builder = OILinkMessages.DASetOption.FontAlias.newBuilder().setOriginal(string2).setAlias(((FontAliases)iOException).getAliasList().get(string2));
                    string.addFontAliasPairs(builder);
                }
            }
            try {
                oILink.DASetOption(oIHandle, 337797, string.build());
            }
            catch (IOException iOException3) {
                throw new OutsideInException("Error setting FontAliasList option", iOException3);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.FontFilterOption) && Options.FontFilter.getOptionScope() == optionScopeValue) {
            iOException = this.getFontFilter();
            OILinkMessages.DASetOption.FontFilter.Builder iOException4 = OILinkMessages.DASetOption.FontFilter.newBuilder().setBExclude(((FontList)iOException).isExcludeList());
            if (((FontList)iOException).getFontsList() != null) {
                iOException = ((FontList)iOException).getFontsList();
                for (String string : iOException) {
                    iOException4.addFontNameList(string);
                }
            }
            try {
                oILink.DASetOption(oIHandle, 337799, iOException4.build());
            }
            catch (IOException l) {
                throw new OutsideInException("Error setting FontFilter option", l);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.FontDirectoriesOption) && Options.FontDirectories.getOptionScope() == optionScopeValue) {
            iOException = this.getFontDirectories();
            String builder5 = null;
            try {
                iOException = iOException.iterator();
                while (iOException.hasNext()) {
                    File file = (File)iOException.next();
                    if (null == builder5) {
                        builder5 = file.getCanonicalPath();
                        continue;
                    }
                    if (isWindows) {
                        builder5 = builder5 + ";" + file.getCanonicalPath();
                        continue;
                    }
                    builder5 = builder5 + ":" + file.getCanonicalPath();
                }
                if (builder5 != null) {
                    oILink.DASetOption(oIHandle, 87540, builder5);
                }
            }
            catch (IOException iOException4) {
                throw new OutsideInException("Error setting FontDirectories option", iOException4);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.WatermarkOption) && Options.Watermark.getOptionScope() == optionScopeValue) {
            iOException = this.getWatermark();
            try {
                if (((Watermark)iOException).m_bEnabled) {
                    oILink.DASetOption(oIHandle, 113, ((Watermark)iOException).getOpacity());
                    oILink.DASetOption(oIHandle, 121, ((Watermark)iOException).getBasicIO());
                    oILink.DASetOption(oIHandle, 115, ((Watermark)iOException).getScalemode().value);
                    if (((Watermark)iOException).getScalemode() == Watermark.ScaleModeValue.PERCENT) {
                        oILink.DASetOption(oIHandle, 116, ((Watermark)iOException).getPercent());
                    }
                    oILink.DASetOption(oIHandle, 125, ((Watermark)iOException).getHorzAnchorPosition());
                    oILink.DASetOption(oIHandle, 126, ((Watermark)iOException).getVertAnchorPosition());
                    oILink.DASetOption(oIHandle, 123, ((Watermark)iOException).getHorzOffset());
                    oILink.DASetOption(oIHandle, 124, ((Watermark)iOException).getVertOffset());
                } else {
                    oILink.DASetOption(oIHandle, 113, 0);
                }
            }
            catch (IOException iOException5) {
                throw new OutsideInException("Error setting Watermark options", iOException5);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.MailHeadersOption) && Options.EmailHeaders.getOptionScope() == optionScopeValue) {
            try {
                iOException = this.getEmailHeaders();
                oILink.DASetOption(oIHandle, 337892, ((MailHeaders)iOException).getBaseline().value);
                OILinkMessages.DASetOption.MailHeaderInfo.Builder builder = OILinkMessages.DASetOption.MailHeaderInfo.newBuilder();
                if (((MailHeaders)iOException).getVisibleStandardHeadersList() != null) {
                    for (MailHeaders.MailTypeValue mailTypeValue : ((MailHeaders)iOException).getVisibleStandardHeadersList().keySet()) {
                        for (MailHeaders.MailHeaderValue mailHeaderValue : ((MailHeaders)iOException).getVisibleStandardHeadersList().get((Object)mailTypeValue)) {
                            builder.setDwHeaderID(mailHeaderValue.value);
                            builder.setDwSubtypeID(mailTypeValue.value);
                            builder.setWsMimeHeaderLabel("");
                            builder.setWsMimeHeaderName("");
                            oILink.DASetOption(oIHandle, 337893, builder.build());
                        }
                    }
                }
                if (((MailHeaders)iOException).getHiddenStandardHeadersList() != null) {
                    for (MailHeaders.MailTypeValue mailTypeValue : ((MailHeaders)iOException).getHiddenStandardHeadersList().keySet()) {
                        for (MailHeaders.MailHeaderValue mailHeaderValue : ((MailHeaders)iOException).getHiddenStandardHeadersList().get((Object)mailTypeValue)) {
                            builder.setDwHeaderID(mailHeaderValue.value);
                            builder.setDwSubtypeID(mailTypeValue.value);
                            builder.setWsMimeHeaderLabel("");
                            builder.setWsMimeHeaderName("");
                            oILink.DASetOption(oIHandle, 337894, builder.build());
                        }
                    }
                }
                long l = 0L;
                if (((MailHeaders)iOException).getVisibleCustomHeadersList() != null) {
                    for (MailHeaders.MailTypeValue mailTypeValue : ((MailHeaders)iOException).getVisibleCustomHeadersList().keySet()) {
                        Map<String, String> map = ((MailHeaders)iOException).getVisibleCustomHeadersList().get((Object)mailTypeValue);
                        for (String string : map.keySet()) {
                            builder.setDwHeaderID(l++);
                            builder.setDwSubtypeID(mailTypeValue.value);
                            builder.setWsMimeHeaderName(string);
                            builder.setWsMimeHeaderLabel(map.get(string));
                            oILink.DASetOption(oIHandle, 337893, builder.build());
                        }
                    }
                }
                if (((MailHeaders)iOException).getHiddenCustomHeadersList() != null) {
                    for (MailHeaders.MailTypeValue mailTypeValue : ((MailHeaders)iOException).getHiddenCustomHeadersList().keySet()) {
                        for (String string : ((MailHeaders)iOException).getHiddenCustomHeadersList().get((Object)mailTypeValue)) {
                            builder.setDwHeaderID(l++);
                            builder.setDwSubtypeID(mailTypeValue.value);
                            builder.setWsMimeHeaderName(string);
                            builder.setWsMimeHeaderLabel("");
                            oILink.DASetOption(oIHandle, 337894, builder.build());
                        }
                    }
                }
            }
            catch (IOException iOException5) {
                throw new OutsideInException("Error setting EmailHeaders option", iOException5);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.PrintRangeOption) && Options.PageRange.getOptionScope() == optionScopeValue) {
            PageRange pageRange = this.getPageRange();
            try {
                if (pageRange.getPrintAll()) {
                    oILink.DASetOption(oIHandle, 337788, 1L);
                } else {
                    oILink.DASetOption(oIHandle, 337788, 3L);
                    oILink.DASetOption(oIHandle, 337789, pageRange.getStartPage());
                    oILink.DASetOption(oIHandle, 337790, pageRange.getStopPage());
                }
            }
            catch (IOException iOException6) {
                throw new OutsideInException("Error setting PrintRange option", iOException6);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.FormatFlagsOption) && Options.ISODateTimes.getOptionScope() == optionScopeValue) {
            long l = 0L;
            if (this.getISODateTimes()) {
                l = 1L;
            }
            if (this.getStrictFile()) {
                l |= 2L;
            }
            try {
                oILink.DASetOption(oIHandle, 273264, l);
            }
            catch (IOException iOException6) {
                throw new OutsideInException("Error setting ISODateTimes option", iOException6);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.GridWrapOption) && Options.GridWrap.getOptionScope() == optionScopeValue) {
            try {
                iOException = this.getGridWrap();
                if (((GridWrapInfo)iOException).m_MaxRowsSet) {
                    oILink.DASetOption(oIHandle, 55, ((GridWrapInfo)iOException).getMaxRows());
                }
                if (((GridWrapInfo)iOException).m_MaxColumnsSet) {
                    oILink.DASetOption(oIHandle, 56, ((GridWrapInfo)iOException).getMaxColumns());
                }
                if (((GridWrapInfo)iOException).m_AdvanceModeSet) {
                    oILink.DASetOption(oIHandle, 57, ((GridWrapInfo)iOException).getAdvanceMode().value);
                }
                if (((GridWrapInfo)iOException).m_EnabledSet) {
                    oILink.DASetOption(oIHandle, 58, ((GridWrapInfo)iOException).isWrappingEnabled() ? 1L : 0L);
                }
            }
            catch (IOException bl) {
                throw new OutsideInException("Error setting GridWrap options", bl);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.PrintFitModeOption) && Options.PageFitMode.getOptionScope() == optionScopeValue) {
            try {
                iOException = this.getPageFitMode();
                oILink.DASetOption(oIHandle, 338287, ((Options.PageFitModeValue)((Object)iOException)).value);
                oILink.DASetOption(oIHandle, 338188, ((Options.PageFitModeValue)((Object)iOException)).value);
            }
            catch (IOException iOException7) {
                throw new OutsideInException("Error setting PageFitMode option", iOException7);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.RenderGridlineOption) && Options.RenderGridlines.getOptionScope() == optionScopeValue) {
            try {
                boolean bl = this.getRenderGridlines();
                oILink.DASetOption(oIHandle, 338282, bl);
                oILink.DASetOption(oIHandle, 338182, bl);
            }
            catch (IOException iOException8) {
                throw new OutsideInException("Error setting RenderGridlines option", iOException8);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.RenderHeadingsOption) && Options.RenderHeadings.getOptionScope() == optionScopeValue) {
            try {
                boolean xMLReference = this.getRenderHeadings();
                oILink.DASetOption(oIHandle, 338283, xMLReference);
                oILink.DASetOption(oIHandle, 338183, xMLReference);
            }
            catch (IOException iOException9) {
                throw new OutsideInException("Error setting RenderHeadings option", iOException9);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.XMLReferenceOption) && Options.XMLDefinitionReference.getOptionScope() == optionScopeValue) {
            try {
                XMLReference embedFontsValue = this.getXMLDefinitionReference();
                oILink.DASetOption(oIHandle, 61, embedFontsValue.getReferenceMethod().value);
                oILink.DASetOption(oIHandle, 91, embedFontsValue.getReferenceMethod().value);
                if (embedFontsValue.getReferenceMethod() != XMLReference.ReferenceMethodValue.NONE) {
                    oILink.DASetOption(oIHandle, 62, embedFontsValue.getDefinitionReference());
                    oILink.DASetOption(oIHandle, 92, embedFontsValue.getDefinitionReference());
                }
            }
            catch (IOException iOException10) {
                throw new OutsideInException("Error setting XMLDefinitionReference option", iOException10);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.EmbedFontsOption) && Options.EmbedFonts.getOptionScope() == optionScopeValue) {
            try {
                Options.EmbedFontsValue fontInfo = this.getEmbedFonts();
                if (fontInfo == Options.EmbedFontsValue.NONE) {
                    oILink.DASetOption(oIHandle, 87542, false);
                } else {
                    oILink.DASetOption(oIHandle, 87542, true);
                    oILink.DASetOption(oIHandle, 87548, fontInfo.value);
                }
            }
            catch (IOException iOException11) {
                throw new OutsideInException("Error setting EmbedFonts options", iOException11);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.RedactionLabelFontOption) && Options.RedactionLabelFont.getOptionScope() == optionScopeValue) {
            try {
                FontInfo fontInfo = this.getRedactionLabelFont();
                oILink.DASetOption(oIHandle, 286160, fontInfo.getFontFace());
                oILink.DASetOption(oIHandle, 286161, (long)fontInfo.getHeight());
            }
            catch (IOException iOException12) {
                throw new OutsideInException("Error setting RedactionLabelFont option", iOException12);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.MargintextFontOption) && Options.MarginTextFont.getOptionScope() == optionScopeValue) {
            try {
                FontInfo iOException7 = this.getMarginTextFont();
                oILink.DASetOption(oIHandle, 286164, iOException7.getFontFace());
                oILink.DASetOption(oIHandle, 286165, (long)iOException7.getHeight());
            }
            catch (IOException iOException8) {
                throw new OutsideInException("Error setting MarginTextFont option", iOException8);
            }
        }
        if (this.m_cumulativeInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.MargintextOption) && Options.MarginText.getOptionScope() == optionScopeValue) {
            try {
                oILink.DASetOption(oIHandle, 286166, this.getMarginText().getPBData());
            }
            catch (IOException iOException9) {
                throw new OutsideInException("Error setting MarginText option", iOException9);
            }
        }
    }

    protected void setPasswordAndNotesId(OILink oILink, OIHandle oIHandle) throws OutsideInException {
        if (this.m_cumulativeInfo.m_passwords != null) {
            OILinkMessages.DASetOption.StringList.Builder builder = OILinkMessages.DASetOption.StringList.newBuilder();
            for (String string : this.m_cumulativeInfo.m_passwords) {
                builder.addStrings(string);
            }
            try {
                oILink.DASetOption(oIHandle, 268697602, builder.build());
            }
            catch (IOException iOException) {
                throw new OutsideInException("Failed to set password option: " + iOException.getMessage(), iOException);
            }
        }
        if (this.m_cumulativeInfo.m_notesidfile != null) {
            try {
                oILink.DASetOption(oIHandle, 0x10040001, this.m_cumulativeInfo.m_notesidfile);
            }
            catch (IOException iOException) {
                throw new OutsideInException("Failed to set Lotus Notes Id: " + iOException.getMessage(), iOException);
            }
        }
    }

    void addOptionToCache(Options options, Object object) {
        this.m_srcInfo.m_optionsCache.put(options, object);
        this.m_cumulativeInfo.m_optionsCache.put(options, object);
        if (options.getSpecialOptionFlag() != null) {
            this.setSpecialOptionFlag(options.getSpecialOptionFlag());
        }
    }

    Object getOptionFromCache(Options options) {
        if (!this.m_cumulativeInfo.m_optionsCache.containsKey(options)) {
            return options.getDefault();
        }
        return this.m_cumulativeInfo.m_optionsCache.get(options);
    }

    protected void setSpecialOptionFlag(Options.SpecialOptionFlag specialOptionFlag) {
        this.m_srcInfo.specialOptionFlags.add(specialOptionFlag);
        this.m_cumulativeInfo.specialOptionFlags.add(specialOptionFlag);
    }

    private OptionsCache setSourceFile(File file, SeekableByteChannel6ToBasicIO seekableByteChannel6ToBasicIO) {
        this.m_srcInfoList.clear();
        if (!this.m_bProcessingFirstFile) {
            this.m_srcInfo = new SourceFileInfo();
            this.m_srcInfo.inheritSourceFileInfo(this.m_cumulativeInfo);
        } else {
            this.m_bProcessingFirstFile = false;
        }
        this.m_srcInfo.file = file;
        this.m_srcInfo.redirect = seekableByteChannel6ToBasicIO;
        this.m_srcInfoList.add(this.m_srcInfo);
        return this;
    }

    @Override
    public OptionsCache setSourceFile(File file) throws OutsideInException {
        if (null == file || !file.exists()) {
            throw new OutsideInException("Source file does not exist");
        }
        return this.setSourceFile(file, null);
    }

    @Override
    public OptionsCache setSourceFile(SeekableByteChannel6 seekableByteChannel6) throws OutsideInException {
        if (null == seekableByteChannel6) {
            throw new OutsideInException("Source SeekableByteChannel6 object cannot be null");
        }
        return this.setSourceFile(null, new SeekableByteChannel6ToBasicIO(seekableByteChannel6));
    }

    @Override
    public OptionsCache setSourceFile(SeekableByteChannel6 seekableByteChannel6, String string) throws OutsideInException {
        if (null == seekableByteChannel6) {
            throw new OutsideInException("Source SeekableByteChannel6 object cannot be null");
        }
        return this.setSourceFile(null, new SeekableByteChannel6ToBasicIO(seekableByteChannel6, string));
    }

    private OptionsCache addSourceFile(File file, SeekableByteChannel6ToBasicIO seekableByteChannel6ToBasicIO) {
        this.m_srcInfo = new SourceFileInfo();
        this.m_srcInfo.file = file;
        this.m_srcInfo.redirect = seekableByteChannel6ToBasicIO;
        this.m_srcInfoList.add(this.m_srcInfo);
        return this;
    }

    @Override
    public OptionsCache addSourceFile(File file) throws OutsideInException {
        if (null == file || !file.exists()) {
            throw new OutsideInException("Source file does not exist");
        }
        return this.addSourceFile(file, null);
    }

    @Override
    public OptionsCache addSourceFile(SeekableByteChannel6 seekableByteChannel6) throws OutsideInException {
        if (null == seekableByteChannel6) {
            throw new OutsideInException("Source SeekableByteChannel6 object cannot be null");
        }
        return this.addSourceFile(null, new SeekableByteChannel6ToBasicIO(seekableByteChannel6));
    }

    @Override
    public OptionsCache addSourceFile(SeekableByteChannel6 seekableByteChannel6, String string) throws OutsideInException {
        if (null == seekableByteChannel6) {
            throw new OutsideInException("Source SeekableByteChannel6 object cannot be null");
        }
        return this.addSourceFile(null, new SeekableByteChannel6ToBasicIO(seekableByteChannel6, string));
    }

    @Override
    public OptionsCache setSourceFormat(FileFormat fileFormat) {
        this.m_srcInfo.format = fileFormat;
        this.m_bDoOpenInput = true;
        return this;
    }

    @Override
    public OptionsCache setDestinationFile(File file) throws OutsideInException {
        try {
            if (!file.getCanonicalFile().getParentFile().exists()) {
                throw new OutsideInException("Destination directory " + file.getCanonicalFile().getParent() + " does not exist");
            }
        }
        catch (IOException iOException) {
            throw new OutsideInException(iOException.getMessage(), iOException);
        }
        this.m_dstFile = file;
        this.m_dstRedirect = null;
        return this;
    }

    @Override
    public OptionsCache setDestinationFile(SeekableByteChannel6 seekableByteChannel6) throws OutsideInException {
        this.m_dstFile = null;
        this.m_dstRedirect = new SeekableByteChannel6ToBasicIO(seekableByteChannel6);
        return this;
    }

    @Override
    public OptionsCache setDestinationFormat(FileFormat fileFormat) {
        this.m_dstFileId = fileFormat;
        return this;
    }

    @Override
    public FileFormat getDestinationFormat() {
        return this.m_dstFileId;
    }

    @Override
    public OptionsCache setCallbackHandler(Callback callback) {
        this.m_srcInfo.callback = callback;
        this.m_cumulativeInfo.callback = callback;
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.CallbackOption);
        return this;
    }

    @Override
    public OptionsCache setPasswordsList(List<String> list) {
        if (list != null) {
            this.m_srcInfo.m_passwords = new LinkedList<String>();
            this.m_cumulativeInfo.m_passwords = new LinkedList<String>();
            this.m_srcInfo.m_passwords.addAll(list);
            this.m_cumulativeInfo.m_passwords.addAll(list);
            this.setSpecialOptionFlag(Options.SpecialOptionFlag.PasswordsOption);
        }
        return this;
    }

    @Override
    public OptionsCache setLotusNotesId(String string) {
        this.m_srcInfo.m_notesidfile = string;
        this.m_cumulativeInfo.m_notesidfile = string;
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.LotusNotesIdOption);
        return this;
    }

    @Override
    public OptionsCache setOpenForNonSequentialAccess(boolean bl) {
        this.m_srcInfo.bOpenForNonSequentialAccess = bl;
        this.m_cumulativeInfo.bOpenForNonSequentialAccess = bl;
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.OpenForNonSequentialAccessOption);
        return this;
    }

    @Override
    public OptionsCache setExportTemplate(File file) throws OutsideInException {
        try {
            this.m_templatefile = null == file ? null : new File(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            throw new OutsideInException("Failed to set export template file: " + iOException.getMessage(), iOException);
        }
        return this;
    }

    @Override
    public OptionsCache setDefaultInputCharacterSet(Options.DefaultInputCharacterSetValue defaultInputCharacterSetValue) {
        this.addOptionToCache(Options.DefaultInputCharacterSet, (Object)defaultInputCharacterSetValue);
        return this;
    }

    @Override
    public Options.DefaultInputCharacterSetValue getDefaultInputCharacterSet() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.DefaultInputCharacterSet)) {
            return (Options.DefaultInputCharacterSetValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.DefaultInputCharacterSet));
        }
        return (Options.DefaultInputCharacterSetValue)((Object)Options.DefaultInputCharacterSet.getDefault());
    }

    @Override
    public OptionsCache setUnmappableCharacter(int n) {
        this.addOptionToCache(Options.UnmappableCharacter, n);
        return this;
    }

    @Override
    public int getUnmappableCharacter() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.UnmappableCharacter)) {
            return (Integer)this.m_cumulativeInfo.m_optionsCache.get(Options.UnmappableCharacter);
        }
        return (Integer)Options.UnmappableCharacter.getDefault();
    }

    @Override
    public OptionsCache setUnicodeByteOrder(Options.UnicodeByteOrderValue unicodeByteOrderValue) {
        this.addOptionToCache(Options.UnicodeByteOrder, (Object)unicodeByteOrderValue);
        return this;
    }

    @Override
    public Options.UnicodeByteOrderValue getUnicodeByteOrder() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.UnicodeByteOrder)) {
            return (Options.UnicodeByteOrderValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.UnicodeByteOrder));
        }
        return (Options.UnicodeByteOrderValue)((Object)Options.UnicodeByteOrder.getDefault());
    }

    @Override
    public OptionsCache setOutputCharacterSet(Options.OutputCharacterSetValue outputCharacterSetValue) {
        this.addOptionToCache(Options.OutputCharacterSet, (Object)outputCharacterSetValue);
        return this;
    }

    @Override
    public Options.OutputCharacterSetValue getOutputCharacterSet() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.OutputCharacterSet)) {
            return (Options.OutputCharacterSetValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.OutputCharacterSet));
        }
        return (Options.OutputCharacterSetValue)((Object)Options.OutputCharacterSet.getDefault());
    }

    @Override
    public OptionsCache setInternalRendering(boolean bl) {
        this.addOptionToCache(Options.InternalRendering, bl);
        return this;
    }

    @Override
    public boolean getInternalRendering() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.InternalRendering)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.InternalRendering);
        }
        return (Boolean)Options.InternalRendering.getDefault();
    }

    @Override
    public OptionsCache setEnableAlphaBlending(boolean bl) {
        this.addOptionToCache(Options.EnableAlphaBlending, bl);
        return this;
    }

    @Override
    public boolean getEnableAlphaBlending() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.EnableAlphaBlending)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.EnableAlphaBlending);
        }
        return (Boolean)Options.EnableAlphaBlending.getDefault();
    }

    @Override
    public OptionsCache setOutputChangeTracking(boolean bl) {
        this.addOptionToCache(Options.OutputChangeTracking, bl);
        return this;
    }

    @Override
    public boolean getOutputChangeTracking() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.OutputChangeTracking)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.OutputChangeTracking);
        }
        return (Boolean)Options.OutputChangeTracking.getDefault();
    }

    @Override
    public OptionsCache setCollapseWhiteSpace(boolean bl) {
        this.addOptionToCache(Options.CollapseWhiteSpace, bl);
        return this;
    }

    @Override
    public boolean getCollapseWhiteSpace() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.CollapseWhiteSpace)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.CollapseWhiteSpace);
        }
        return (Boolean)Options.CollapseWhiteSpace.getDefault();
    }

    @Override
    public OptionsCache setExtractEmbeddedFiles(Options.ExtractEmbeddedFilesValue extractEmbeddedFilesValue) {
        this.addOptionToCache(Options.ExtractEmbeddedFiles, (Object)extractEmbeddedFilesValue);
        return this;
    }

    @Override
    public Options.ExtractEmbeddedFilesValue getExtractEmbeddedFiles() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ExtractEmbeddedFiles)) {
            return (Options.ExtractEmbeddedFilesValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.ExtractEmbeddedFiles));
        }
        return (Options.ExtractEmbeddedFilesValue)((Object)Options.ExtractEmbeddedFiles.getDefault());
    }

    @Override
    public OptionsCache setHTMLFlavor(Options.HTMLFlavorValue hTMLFlavorValue) {
        this.addOptionToCache(Options.HTMLFlavor, (Object)hTMLFlavorValue);
        return this;
    }

    @Override
    public Options.HTMLFlavorValue getHTMLFlavor() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.HTMLFlavor)) {
            return (Options.HTMLFlavorValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.HTMLFlavor));
        }
        return (Options.HTMLFlavorValue)((Object)Options.HTMLFlavor.getDefault());
    }

    @Override
    public OptionsCache setHTMLOutputFormatting(boolean bl) {
        this.addOptionToCache(Options.HTMLOutputFormatting, bl);
        return this;
    }

    @Override
    public boolean getHTMLOutputFormatting() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.HTMLOutputFormatting)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.HTMLOutputFormatting);
        }
        return (Boolean)Options.HTMLOutputFormatting.getDefault();
    }

    @Override
    public OptionsCache setShowHiddenText(boolean bl) {
        this.addOptionToCache(Options.ShowHiddenText, bl);
        return this;
    }

    @Override
    public boolean getShowHiddenText() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ShowHiddenText)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.ShowHiddenText);
        }
        return (Boolean)Options.ShowHiddenText.getDefault();
    }

    @Override
    public OptionsCache setSimpleStyleNames(boolean bl) {
        this.addOptionToCache(Options.SimpleStyleNames, bl);
        return this;
    }

    @Override
    public boolean getSimpleStyleNames() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.SimpleStyleNames)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.SimpleStyleNames);
        }
        return (Boolean)Options.SimpleStyleNames.getDefault();
    }

    @Override
    public OptionsCache setShowHiddenSpreadSheetData(boolean bl) {
        this.addOptionToCache(Options.ShowHiddenSpreadSheetData, bl);
        return this;
    }

    @Override
    public boolean getShowHiddenSpreadSheetData() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ShowHiddenSpreadSheetData)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.ShowHiddenSpreadSheetData);
        }
        return (Boolean)Options.ShowHiddenSpreadSheetData.getDefault();
    }

    @Override
    public OptionsCache setFallbackFormat(Options.FallbackFormatValue fallbackFormatValue) {
        this.addOptionToCache(Options.FallbackFormat, (Object)fallbackFormatValue);
        return this;
    }

    @Override
    public Options.FallbackFormatValue getFallbackFormat() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.FallbackFormat)) {
            return (Options.FallbackFormatValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.FallbackFormat));
        }
        return (Options.FallbackFormatValue)((Object)Options.FallbackFormat.getDefault());
    }

    @Override
    public OptionsCache setExtractXMPMetadata(boolean bl) {
        this.addOptionToCache(Options.ExtractXMPMetadata, bl);
        return this;
    }

    @Override
    public boolean getExtractXMPMetadata() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ExtractXMPMetadata)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.ExtractXMPMetadata);
        }
        return (Boolean)Options.ExtractXMPMetadata.getDefault();
    }

    @Override
    public OptionsCache setParseXMPMetadata(boolean bl) {
        this.addOptionToCache(Options.ParseXMPMetadata, bl);
        return this;
    }

    @Override
    public boolean getParseXMPMetadata() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ParseXMPMetadata)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.ParseXMPMetadata);
        }
        return (Boolean)Options.ParseXMPMetadata.getDefault();
    }

    @Override
    public OptionsCache setPerformExtendedFI(boolean bl) {
        this.addOptionToCache(Options.PerformExtendedFI, bl);
        return this;
    }

    @Override
    public boolean getPerformExtendedFI() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PerformExtendedFI)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.PerformExtendedFI);
        }
        return (Boolean)Options.PerformExtendedFI.getDefault();
    }

    @Override
    public OptionsCache setLotusNotesDirectory(String string) {
        this.addOptionToCache(Options.LotusNotesDirectory, string);
        return this;
    }

    @Override
    public String getLotusNotesDirectory() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.LotusNotesDirectory)) {
            return (String)this.m_cumulativeInfo.m_optionsCache.get(Options.LotusNotesDirectory);
        }
        return (String)Options.LotusNotesDirectory.getDefault();
    }

    @Override
    public OptionsCache setPDFReorderBiDi(Options.PDFReorderBiDiValue pDFReorderBiDiValue) {
        this.addOptionToCache(Options.PDFReorderBiDi, (Object)pDFReorderBiDiValue);
        return this;
    }

    @Override
    public Options.PDFReorderBiDiValue getPDFReorderBiDi() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PDFReorderBiDi)) {
            return (Options.PDFReorderBiDiValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.PDFReorderBiDi));
        }
        return (Options.PDFReorderBiDiValue)((Object)Options.PDFReorderBiDi.getDefault());
    }

    @Override
    public OptionsCache setPDFDetectBiDiBit(Options.PDFBiDiDetectValue pDFBiDiDetectValue) {
        this.addOptionToCache(Options.PDFDetectBiDiBit, (Object)pDFBiDiDetectValue);
        return this;
    }

    @Override
    public Options.PDFBiDiDetectValue getPDFDetectBiDiBit() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PDFDetectBiDiBit)) {
            return (Options.PDFBiDiDetectValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.PDFDetectBiDiBit));
        }
        return (Options.PDFBiDiDetectValue)((Object)Options.PDFDetectBiDiBit.getDefault());
    }

    @Override
    public OptionsCache setPDFWordSpacingFactor(float f) {
        this.addOptionToCache(Options.PDFWordSpacingFactor, Float.valueOf(f));
        return this;
    }

    @Override
    public float getPDFWordSpacingFactor() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PDFWordSpacingFactor)) {
            return ((Float)this.m_cumulativeInfo.m_optionsCache.get(Options.PDFWordSpacingFactor)).floatValue();
        }
        return ((Float)Options.PDFWordSpacingFactor.getDefault()).floatValue();
    }

    @Override
    public OptionsCache setPDFInputMaxEmbeddedObjects(long l) {
        this.addOptionToCache(Options.PDFInputMaxEmbeddedObjects, l);
        return this;
    }

    @Override
    public long getPDFInputMaxEmbeddedObjects() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PDFInputMaxEmbeddedObjects)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.PDFInputMaxEmbeddedObjects);
        }
        return (Long)Options.PDFInputMaxEmbeddedObjects.getDefault();
    }

    @Override
    public OptionsCache setPDFInputMaxVectorPaths(long l) {
        this.addOptionToCache(Options.PDFInputMaxVectorPaths, l);
        return this;
    }

    @Override
    public long getPDFInputMaxVectorPaths() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PDFInputMaxVectorPaths)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.PDFInputMaxVectorPaths);
        }
        return (Long)Options.PDFInputMaxVectorPaths.getDefault();
    }

    @Override
    public OptionsCache setTimeZoneOffset(long l) {
        this.addOptionToCache(Options.TimeZoneOffset, l);
        return this;
    }

    @Override
    public long getTimeZoneOffset() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.TimeZoneOffset)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.TimeZoneOffset);
        }
        return (Long)Options.TimeZoneOffset.getDefault();
    }

    @Override
    public OptionsCache setISODateTimes(boolean bl) {
        this.addOptionToCache(Options.ISODateTimes, bl);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.FormatFlagsOption);
        return this;
    }

    @Override
    public boolean getISODateTimes() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ISODateTimes)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.ISODateTimes);
        }
        return (Boolean)Options.ISODateTimes.getDefault();
    }

    @Override
    public OptionsCache setStrictFile(boolean bl) {
        this.addOptionToCache(Options.StrictFile, bl);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.FormatFlagsOption);
        return this;
    }

    @Override
    public boolean getStrictFile() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.StrictFile)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.StrictFile);
        }
        return (Boolean)Options.StrictFile.getDefault();
    }

    @Override
    public OptionsCache setIgnorePassword(boolean bl) {
        this.addOptionToCache(Options.IgnorePassword, bl);
        return this;
    }

    @Override
    public boolean getIgnorePassword() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.IgnorePassword)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.IgnorePassword);
        }
        return (Boolean)Options.IgnorePassword.getDefault();
    }

    @Override
    public OptionsCache setBiDiReorderMethod(Options.BiDiReorderMethodValue biDiReorderMethodValue) {
        this.addOptionToCache(Options.BiDiReorderMethod, (Object)biDiReorderMethodValue);
        return this;
    }

    @Override
    public Options.BiDiReorderMethodValue getBiDiReorderMethod() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.BiDiReorderMethod)) {
            return (Options.BiDiReorderMethodValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.BiDiReorderMethod));
        }
        return (Options.BiDiReorderMethodValue)((Object)Options.BiDiReorderMethod.getDefault());
    }

    @Override
    public OptionsCache setIECondCommentMode(EnumSet<Options.IECondCommentFlagValues> enumSet) {
        if (null == enumSet) {
            throw new IllegalArgumentException("IECondCommentMode Option value cannot be null");
        }
        this.addOptionToCache(Options.IECondCommentMode, enumSet);
        return this;
    }

    @Override
    public EnumSet<Options.IECondCommentFlagValues> getIECondCommentMode() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.IECondCommentMode)) {
            return (EnumSet)this.m_cumulativeInfo.m_optionsCache.get(Options.IECondCommentMode);
        }
        return (EnumSet)Options.IECondCommentMode.getDefault();
    }

    @Override
    public OptionsCache setShowArchiveFullPath(boolean bl) {
        this.addOptionToCache(Options.ShowArchiveFullPath, bl);
        return this;
    }

    @Override
    public boolean getShowArchiveFullPath() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ShowArchiveFullPath)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.ShowArchiveFullPath);
        }
        return (Boolean)Options.ShowArchiveFullPath.getDefault();
    }

    @Override
    public OptionsCache setGenerateExcelRevisions(boolean bl) {
        this.addOptionToCache(Options.GenerateExcelRevisions, bl);
        return this;
    }

    @Override
    public boolean getGenerateExcelRevisions() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GenerateExcelRevisions)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.GenerateExcelRevisions);
        }
        return (Boolean)Options.GenerateExcelRevisions.getDefault();
    }

    @Override
    public OptionsCache setProcessOLEEmbeddingMode(Options.ProcessOLEEmbeddingModeValue processOLEEmbeddingModeValue) {
        this.addOptionToCache(Options.ProcessOLEEmbeddingMode, (Object)processOLEEmbeddingModeValue);
        return this;
    }

    @Override
    public Options.ProcessOLEEmbeddingModeValue getProcessOLEEmbeddingMode() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ProcessOLEEmbeddingMode)) {
            return (Options.ProcessOLEEmbeddingModeValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.ProcessOLEEmbeddingMode));
        }
        return (Options.ProcessOLEEmbeddingModeValue)((Object)Options.ProcessOLEEmbeddingMode.getDefault());
    }

    @Override
    public OptionsCache setDropPDFHyphens(boolean bl) {
        this.addOptionToCache(Options.DropPDFHyphens, bl);
        return this;
    }

    @Override
    public boolean getDropPDFHyphens() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.DropPDFHyphens)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.DropPDFHyphens);
        }
        return (Boolean)Options.DropPDFHyphens.getDefault();
    }

    @Override
    public OptionsCache setApplyZLIBCompression(boolean bl) {
        this.addOptionToCache(Options.ApplyZLIBCompression, bl);
        return this;
    }

    @Override
    public boolean getApplyZLIBCompression() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ApplyZLIBCompression)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.ApplyZLIBCompression);
        }
        return (Boolean)Options.ApplyZLIBCompression.getDefault();
    }

    @Override
    public OptionsCache setInterlacedGIFs(boolean bl) {
        this.addOptionToCache(Options.InterlacedGIFs, bl);
        return this;
    }

    @Override
    public boolean getInterlacedGIFs() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.InterlacedGIFs)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.InterlacedGIFs);
        }
        return (Boolean)Options.InterlacedGIFs.getDefault();
    }

    @Override
    public OptionsCache setCropToContent(boolean bl) {
        this.addOptionToCache(Options.CropToContent, bl);
        return this;
    }

    @Override
    public boolean getCropToContent() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.CropToContent)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.CropToContent);
        }
        return (Boolean)Options.CropToContent.getDefault();
    }

    @Override
    public OptionsCache setGraphicHeight(long l) {
        this.addOptionToCache(Options.GraphicHeight, l);
        return this;
    }

    @Override
    public long getGraphicHeight() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GraphicHeight)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.GraphicHeight);
        }
        return (Long)Options.GraphicHeight.getDefault();
    }

    @Override
    public OptionsCache setGraphicHeightLimit(long l) {
        this.addOptionToCache(Options.GraphicHeightLimit, l);
        return this;
    }

    @Override
    public long getGraphicHeightLimit() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GraphicHeightLimit)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.GraphicHeightLimit);
        }
        return (Long)Options.GraphicHeightLimit.getDefault();
    }

    @Override
    public OptionsCache setGraphicOutputDPI(long l) {
        this.addOptionToCache(Options.GraphicOutputDPI, l);
        return this;
    }

    @Override
    public long getGraphicOutputDPI() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GraphicOutputDPI)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.GraphicOutputDPI);
        }
        return (Long)Options.GraphicOutputDPI.getDefault();
    }

    @Override
    public OptionsCache setGraphicSizeLimit(long l) {
        this.addOptionToCache(Options.GraphicSizeLimit, l);
        return this;
    }

    @Override
    public long getGraphicSizeLimit() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GraphicSizeLimit)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.GraphicSizeLimit);
        }
        return (Long)Options.GraphicSizeLimit.getDefault();
    }

    @Override
    public OptionsCache setTransparencyColor(ColorInfo colorInfo) {
        this.addOptionToCache(Options.TransparencyColor, colorInfo);
        return this;
    }

    @Override
    public ColorInfo getTransparencyColor() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.TransparencyColor)) {
            return (ColorInfo)this.m_cumulativeInfo.m_optionsCache.get(Options.TransparencyColor);
        }
        return (ColorInfo)Options.TransparencyColor.getDefault();
    }

    @Override
    public OptionsCache setGraphicWidth(long l) {
        this.addOptionToCache(Options.GraphicWidth, l);
        return this;
    }

    @Override
    public long getGraphicWidth() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GraphicWidth)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.GraphicWidth);
        }
        return (Long)Options.GraphicWidth.getDefault();
    }

    @Override
    public OptionsCache setGraphicWidthLimit(long l) {
        this.addOptionToCache(Options.GraphicWidthLimit, l);
        return this;
    }

    @Override
    public long getGraphicWidthLimit() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GraphicWidthLimit)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.GraphicWidthLimit);
        }
        return (Long)Options.GraphicWidthLimit.getDefault();
    }

    @Override
    public OptionsCache setGraphicRenderAsPage(boolean bl) {
        this.addOptionToCache(Options.GraphicRenderAsPage, bl);
        return this;
    }

    @Override
    public boolean getGraphicRenderAsPage() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GraphicRenderAsPage)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.GraphicRenderAsPage);
        }
        return (Boolean)Options.GraphicRenderAsPage.getDefault();
    }

    @Override
    public OptionsCache setGraphicSizeMethod(Options.GraphicSizeMethodValue graphicSizeMethodValue) {
        this.addOptionToCache(Options.GraphicSizeMethod, (Object)graphicSizeMethodValue);
        return this;
    }

    @Override
    public Options.GraphicSizeMethodValue getGraphicSizeMethod() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GraphicSizeMethod)) {
            return (Options.GraphicSizeMethodValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.GraphicSizeMethod));
        }
        return (Options.GraphicSizeMethodValue)((Object)Options.GraphicSizeMethod.getDefault());
    }

    @Override
    public OptionsCache setTIFFColorSpace(Options.TIFFColorSpaceValue tIFFColorSpaceValue) {
        this.addOptionToCache(Options.TIFFColorSpace, (Object)tIFFColorSpaceValue);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.TiffOptions);
        return this;
    }

    @Override
    public Options.TIFFColorSpaceValue getTIFFColorSpace() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.TIFFColorSpace)) {
            return (Options.TIFFColorSpaceValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.TIFFColorSpace));
        }
        return (Options.TIFFColorSpaceValue)((Object)Options.TIFFColorSpace.getDefault());
    }

    @Override
    public OptionsCache setTIFFCompression(Options.TIFFCompressionValue tIFFCompressionValue) {
        this.addOptionToCache(Options.TIFFCompression, (Object)tIFFCompressionValue);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.TiffOptions);
        return this;
    }

    @Override
    public Options.TIFFCompressionValue getTIFFCompression() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.TIFFCompression)) {
            return (Options.TIFFCompressionValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.TIFFCompression));
        }
        return (Options.TIFFCompressionValue)((Object)Options.TIFFCompression.getDefault());
    }

    @Override
    public OptionsCache setTIFFMultiPage(boolean bl) {
        this.addOptionToCache(Options.TIFFMultiPage, bl);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.TiffOptions);
        return this;
    }

    @Override
    public boolean getTIFFMultiPage() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.TIFFMultiPage)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.TIFFMultiPage);
        }
        return (Boolean)Options.TIFFMultiPage.getDefault();
    }

    @Override
    public OptionsCache setTIFFByteOrder(Options.TIFFByteOrderValue tIFFByteOrderValue) {
        this.addOptionToCache(Options.TIFFByteOrder, (Object)tIFFByteOrderValue);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.TiffOptions);
        return this;
    }

    @Override
    public Options.TIFFByteOrderValue getTIFFByteOrder() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.TIFFByteOrder)) {
            return (Options.TIFFByteOrderValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.TIFFByteOrder));
        }
        return (Options.TIFFByteOrderValue)((Object)Options.TIFFByteOrder.getDefault());
    }

    @Override
    public OptionsCache setTIFFFillOrder(Options.TIFFFillOrderValue tIFFFillOrderValue) {
        this.addOptionToCache(Options.TIFFFillOrder, (Object)tIFFFillOrderValue);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.TiffOptions);
        return this;
    }

    @Override
    public Options.TIFFFillOrderValue getTIFFFillOrder() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.TIFFFillOrder)) {
            return (Options.TIFFFillOrderValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.TIFFFillOrder));
        }
        return (Options.TIFFFillOrderValue)((Object)Options.TIFFFillOrder.getDefault());
    }

    @Override
    public OptionsCache setJPEGQuality(long l) throws OutsideInException {
        if (l < 1L) {
            throw new OutsideInException("JPEGQuality Option value out of bounds");
        }
        if (l > 100L) {
            throw new OutsideInException("JPEGQuality Option value out of bounds");
        }
        this.addOptionToCache(Options.JPEGQuality, l);
        return this;
    }

    @Override
    public long getJPEGQuality() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.JPEGQuality)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.JPEGQuality);
        }
        return (Long)Options.JPEGQuality.getDefault();
    }

    @Override
    public OptionsCache setQuickThumbnail(boolean bl) {
        this.addOptionToCache(Options.QuickThumbnail, bl);
        return this;
    }

    @Override
    public boolean getQuickThumbnail() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.QuickThumbnail)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.QuickThumbnail);
        }
        return (Boolean)Options.QuickThumbnail.getDefault();
    }

    @Override
    public OptionsCache setImagePassthrough(boolean bl) {
        this.addOptionToCache(Options.ImagePassthrough, bl);
        return this;
    }

    @Override
    public boolean getImagePassthrough() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ImagePassthrough)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.ImagePassthrough);
        }
        return (Boolean)Options.ImagePassthrough.getDefault();
    }

    @Override
    public OptionsCache setAcceptAlternateGraphics(boolean bl) {
        this.addOptionToCache(Options.AcceptAlternateGraphics, bl);
        return this;
    }

    @Override
    public boolean getAcceptAlternateGraphics() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.AcceptAlternateGraphics)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.AcceptAlternateGraphics);
        }
        return (Boolean)Options.AcceptAlternateGraphics.getDefault();
    }

    @Override
    public OptionsCache setOutputGraphicType(Options.OutputGraphicTypeValue outputGraphicTypeValue) {
        this.addOptionToCache(Options.OutputGraphicType, (Object)outputGraphicTypeValue);
        return this;
    }

    @Override
    public Options.OutputGraphicTypeValue getOutputGraphicType() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.OutputGraphicType)) {
            return (Options.OutputGraphicTypeValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.OutputGraphicType));
        }
        return (Options.OutputGraphicTypeValue)((Object)Options.OutputGraphicType.getDefault());
    }

    @Override
    public OptionsCache setDetectGrayScaleAsColor(boolean bl) {
        this.addOptionToCache(Options.DetectGrayScaleAsColor, bl);
        return this;
    }

    @Override
    public boolean getDetectGrayScaleAsColor() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.DetectGrayScaleAsColor)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.DetectGrayScaleAsColor);
        }
        return (Boolean)Options.DetectGrayScaleAsColor.getDefault();
    }

    @Override
    public OptionsCache setPageFitMode(Options.PageFitModeValue pageFitModeValue) {
        this.addOptionToCache(Options.PageFitMode, (Object)pageFitModeValue);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.PrintFitModeOption);
        return this;
    }

    @Override
    public Options.PageFitModeValue getPageFitMode() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PageFitMode)) {
            return (Options.PageFitModeValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.PageFitMode));
        }
        return (Options.PageFitModeValue)((Object)Options.PageFitMode.getDefault());
    }

    @Override
    public OptionsCache setRenderGridlines(boolean bl) {
        this.addOptionToCache(Options.RenderGridlines, bl);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.RenderGridlineOption);
        return this;
    }

    @Override
    public boolean getRenderGridlines() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.RenderGridlines)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.RenderGridlines);
        }
        return (Boolean)Options.RenderGridlines.getDefault();
    }

    @Override
    public OptionsCache setRenderHeadings(boolean bl) {
        this.addOptionToCache(Options.RenderHeadings, bl);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.RenderHeadingsOption);
        return this;
    }

    @Override
    public boolean getRenderHeadings() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.RenderHeadings)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.RenderHeadings);
        }
        return (Boolean)Options.RenderHeadings.getDefault();
    }

    @Override
    public OptionsCache setGridMaxPageHeight(long l) {
        this.addOptionToCache(Options.GridMaxPageHeight, l);
        return this;
    }

    @Override
    public long getGridMaxPageHeight() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GridMaxPageHeight)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.GridMaxPageHeight);
        }
        return (Long)Options.GridMaxPageHeight.getDefault();
    }

    @Override
    public OptionsCache setGridMaxPageWidth(long l) {
        this.addOptionToCache(Options.GridMaxPageWidth, l);
        return this;
    }

    @Override
    public long getGridMaxPageWidth() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GridMaxPageWidth)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.GridMaxPageWidth);
        }
        return (Long)Options.GridMaxPageWidth.getDefault();
    }

    @Override
    public OptionsCache setPageDirection(Options.PageDirectionValue pageDirectionValue) {
        this.addOptionToCache(Options.PageDirection, (Object)pageDirectionValue);
        return this;
    }

    @Override
    public Options.PageDirectionValue getPageDirection() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PageDirection)) {
            return (Options.PageDirectionValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.PageDirection));
        }
        return (Options.PageDirectionValue)((Object)Options.PageDirection.getDefault());
    }

    @Override
    public OptionsCache setPageScalePercent(long l) throws OutsideInException {
        if (l < 1L) {
            throw new OutsideInException("PageScalePercent Option value out of bounds");
        }
        if (l > 100L) {
            throw new OutsideInException("PageScalePercent Option value out of bounds");
        }
        this.addOptionToCache(Options.PageScalePercent, l);
        return this;
    }

    @Override
    public long getPageScalePercent() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PageScalePercent)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.PageScalePercent);
        }
        return (Long)Options.PageScalePercent.getDefault();
    }

    @Override
    public OptionsCache setFitHeightToPages(long l) {
        this.addOptionToCache(Options.FitHeightToPages, l);
        return this;
    }

    @Override
    public long getFitHeightToPages() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.FitHeightToPages)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.FitHeightToPages);
        }
        return (Long)Options.FitHeightToPages.getDefault();
    }

    @Override
    public OptionsCache setFitWidthToPages(long l) {
        this.addOptionToCache(Options.FitWidthToPages, l);
        return this;
    }

    @Override
    public long getFitWidthToPages() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.FitWidthToPages)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.FitWidthToPages);
        }
        return (Long)Options.FitWidthToPages.getDefault();
    }

    @Override
    public OptionsCache setShowHiddenCells(boolean bl) {
        this.addOptionToCache(Options.ShowHiddenCells, bl);
        return this;
    }

    @Override
    public boolean getShowHiddenCells() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ShowHiddenCells)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.ShowHiddenCells);
        }
        return (Boolean)Options.ShowHiddenCells.getDefault();
    }

    @Override
    public OptionsCache setShowColumnHeadings(boolean bl) {
        this.addOptionToCache(Options.ShowColumnHeadings, bl);
        return this;
    }

    @Override
    public boolean getShowColumnHeadings() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ShowColumnHeadings)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.ShowColumnHeadings);
        }
        return (Boolean)Options.ShowColumnHeadings.getDefault();
    }

    @Override
    public OptionsCache setBorderMode(Options.BorderModeValue borderModeValue) {
        this.addOptionToCache(Options.BorderMode, (Object)borderModeValue);
        return this;
    }

    @Override
    public Options.BorderModeValue getBorderMode() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.BorderMode)) {
            return (Options.BorderModeValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.BorderMode));
        }
        return (Options.BorderModeValue)((Object)Options.BorderMode.getDefault());
    }

    @Override
    public OptionsCache setSuppressEmptyCells(boolean bl) {
        this.addOptionToCache(Options.SuppressEmptyCells, bl);
        return this;
    }

    @Override
    public boolean getSuppressEmptyCells() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.SuppressEmptyCells)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.SuppressEmptyCells);
        }
        return (Boolean)Options.SuppressEmptyCells.getDefault();
    }

    @Override
    public OptionsCache setDefaultPageSize(PageInfo pageInfo) {
        if (null == pageInfo) {
            throw new IllegalArgumentException("DefaultPageSize Option value cannot be null");
        }
        this.addOptionToCache(Options.DefaultPageSize, pageInfo);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.DefaultPageSizeOption);
        return this;
    }

    @Override
    public PageInfo getDefaultPageSize() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.DefaultPageSize)) {
            return (PageInfo)this.m_cumulativeInfo.m_optionsCache.get(Options.DefaultPageSize);
        }
        return (PageInfo)Options.DefaultPageSize.getDefault();
    }

    @Override
    public OptionsCache setDefaultPageMargins(Margins margins) {
        if (null == margins) {
            throw new IllegalArgumentException("DefaultPageMargins Option value cannot be null");
        }
        this.addOptionToCache(Options.DefaultPageMargins, margins);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.DefaultPrintMarginOption);
        return this;
    }

    @Override
    public Margins getDefaultPageMargins() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.DefaultPageMargins)) {
            return (Margins)this.m_cumulativeInfo.m_optionsCache.get(Options.DefaultPageMargins);
        }
        return (Margins)Options.DefaultPageMargins.getDefault();
    }

    @Override
    public OptionsCache setUseDocumentPageSettings(boolean bl) {
        this.addOptionToCache(Options.UseDocumentPageSettings, bl);
        return this;
    }

    @Override
    public boolean getUseDocumentPageSettings() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.UseDocumentPageSettings)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.UseDocumentPageSettings);
        }
        return (Boolean)Options.UseDocumentPageSettings.getDefault();
    }

    @Override
    public OptionsCache setPageRange(PageRange pageRange) {
        if (null == pageRange) {
            throw new IllegalArgumentException("PageRange Option value cannot be null");
        }
        this.addOptionToCache(Options.PageRange, pageRange);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.PrintRangeOption);
        return this;
    }

    @Override
    public PageRange getPageRange() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PageRange)) {
            return (PageRange)this.m_cumulativeInfo.m_optionsCache.get(Options.PageRange);
        }
        return (PageRange)Options.PageRange.getDefault();
    }

    @Override
    public OptionsCache setLinearizePDFOutput(boolean bl) {
        this.addOptionToCache(Options.LinearizePDFOutput, bl);
        return this;
    }

    @Override
    public boolean getLinearizePDFOutput() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.LinearizePDFOutput)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.LinearizePDFOutput);
        }
        return (Boolean)Options.LinearizePDFOutput.getDefault();
    }

    @Override
    public OptionsCache setEmailHeaders(MailHeaders mailHeaders) {
        if (null == mailHeaders) {
            throw new IllegalArgumentException("EmailHeaders Option value cannot be null");
        }
        this.addOptionToCache(Options.EmailHeaders, mailHeaders);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.MailHeadersOption);
        return this;
    }

    @Override
    public MailHeaders getEmailHeaders() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.EmailHeaders)) {
            return (MailHeaders)this.m_cumulativeInfo.m_optionsCache.get(Options.EmailHeaders);
        }
        return (MailHeaders)Options.EmailHeaders.getDefault();
    }

    @Override
    public OptionsCache setAppendEmailAttachments(boolean bl) {
        this.addOptionToCache(Options.AppendEmailAttachments, bl);
        return this;
    }

    @Override
    public boolean getAppendEmailAttachments() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.AppendEmailAttachments)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.AppendEmailAttachments);
        }
        return (Boolean)Options.AppendEmailAttachments.getDefault();
    }

    @Override
    public OptionsCache setStrokeOutText(boolean bl) {
        this.addOptionToCache(Options.StrokeOutText, bl);
        return this;
    }

    @Override
    public boolean getStrokeOutText() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.StrokeOutText)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.StrokeOutText);
        }
        return (Boolean)Options.StrokeOutText.getDefault();
    }

    @Override
    public OptionsCache setRenderEmbeddedFonts(boolean bl) {
        this.addOptionToCache(Options.RenderEmbeddedFonts, bl);
        return this;
    }

    @Override
    public boolean getRenderEmbeddedFonts() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.RenderEmbeddedFonts)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.RenderEmbeddedFonts);
        }
        return (Boolean)Options.RenderEmbeddedFonts.getDefault();
    }

    @Override
    public OptionsCache setDefaultRenderFont(FontInfo fontInfo) {
        if (null == fontInfo) {
            throw new IllegalArgumentException("DefaultRenderFont Option value cannot be null");
        }
        this.addOptionToCache(Options.DefaultRenderFont, fontInfo);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.DefaultPrintFontOption);
        return this;
    }

    @Override
    public FontInfo getDefaultRenderFont() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.DefaultRenderFont)) {
            return (FontInfo)this.m_cumulativeInfo.m_optionsCache.get(Options.DefaultRenderFont);
        }
        return (FontInfo)Options.DefaultRenderFont.getDefault();
    }

    @Override
    public OptionsCache setFontAliasList(FontAliases fontAliases) {
        if (null == fontAliases) {
            throw new IllegalArgumentException("FontAliasList Option value cannot be null");
        }
        this.addOptionToCache(Options.FontAliasList, fontAliases);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.FontAliasOption);
        return this;
    }

    @Override
    public FontAliases getFontAliasList() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.FontAliasList)) {
            return (FontAliases)this.m_cumulativeInfo.m_optionsCache.get(Options.FontAliasList);
        }
        return (FontAliases)Options.FontAliasList.getDefault();
    }

    @Override
    public OptionsCache setEmbedFonts(Options.EmbedFontsValue embedFontsValue) {
        this.addOptionToCache(Options.EmbedFonts, (Object)embedFontsValue);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.EmbedFontsOption);
        return this;
    }

    @Override
    public Options.EmbedFontsValue getEmbedFonts() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.EmbedFonts)) {
            return (Options.EmbedFontsValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.EmbedFonts));
        }
        return (Options.EmbedFontsValue)((Object)Options.EmbedFonts.getDefault());
    }

    @Override
    public OptionsCache setFontDirectories(List<File> list) throws OutsideInException {
        if (null == list) {
            return this;
        }
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file : list) {
            String string = null;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new OutsideInException(iOException.getMessage(), iOException);
            }
            if (!file.exists()) {
                throw new OutsideInException("Font directory " + string + " does not exist");
            }
            if (!file.isDirectory()) {
                throw new OutsideInException("Font directory " + string + " is not a valid directory");
            }
            linkedList.add(new File(string));
        }
        this.addOptionToCache(Options.FontDirectories, linkedList);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.FontDirectoriesOption);
        return this;
    }

    @Override
    public List<File> getFontDirectories() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.FontDirectories)) {
            List list = (List)this.m_cumulativeInfo.m_optionsCache.get(Options.FontDirectories);
            LinkedList<File> linkedList = new LinkedList<File>();
            for (File file : list) {
                linkedList.add(file);
            }
            return linkedList;
        }
        return null;
    }

    @Override
    public OptionsCache setFontFilter(FontList fontList) {
        if (null == fontList) {
            throw new IllegalArgumentException("FontFilter Option value cannot be null");
        }
        this.addOptionToCache(Options.FontFilter, fontList);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.FontFilterOption);
        return this;
    }

    @Override
    public FontList getFontFilter() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.FontFilter)) {
            return (FontList)this.m_cumulativeInfo.m_optionsCache.get(Options.FontFilter);
        }
        return (FontList)Options.FontFilter.getDefault();
    }

    @Override
    public OptionsCache setWatermark(Watermark watermark) {
        if (null == watermark) {
            throw new IllegalArgumentException("Watermark Option value cannot be null");
        }
        this.addOptionToCache(Options.Watermark, watermark);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.WatermarkOption);
        return this;
    }

    @Override
    public Watermark getWatermark() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.Watermark)) {
            return (Watermark)this.m_cumulativeInfo.m_optionsCache.get(Options.Watermark);
        }
        return (Watermark)Options.Watermark.getDefault();
    }

    @Override
    public OptionsCache setTempDirectory(String string) {
        this.addOptionToCache(Options.TempDirectory, string);
        return this;
    }

    @Override
    public String getTempDirectory() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.TempDirectory)) {
            return (String)this.m_cumulativeInfo.m_optionsCache.get(Options.TempDirectory);
        }
        return (String)Options.TempDirectory.getDefault();
    }

    @Override
    public OptionsCache setDocumentMemoryMode(Options.DocumentMemoryModeValue documentMemoryModeValue) {
        this.addOptionToCache(Options.DocumentMemoryMode, (Object)documentMemoryModeValue);
        return this;
    }

    @Override
    public Options.DocumentMemoryModeValue getDocumentMemoryMode() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.DocumentMemoryMode)) {
            return (Options.DocumentMemoryModeValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.DocumentMemoryMode));
        }
        return (Options.DocumentMemoryModeValue)((Object)Options.DocumentMemoryMode.getDefault());
    }

    @Override
    public OptionsCache setExportPerformanceMode(Options.ExportPerformanceModeValue exportPerformanceModeValue) {
        this.addOptionToCache(Options.ExportPerformanceMode, (Object)exportPerformanceModeValue);
        return this;
    }

    @Override
    public Options.ExportPerformanceModeValue getExportPerformanceMode() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ExportPerformanceMode)) {
            return (Options.ExportPerformanceModeValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.ExportPerformanceMode));
        }
        return (Options.ExportPerformanceModeValue)((Object)Options.ExportPerformanceMode.getDefault());
    }

    @Override
    public OptionsCache setEnableAllSubObjects(boolean bl) {
        this.addOptionToCache(Options.EnableAllSubObjects, bl);
        return this;
    }

    @Override
    public boolean getEnableAllSubObjects() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.EnableAllSubObjects)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.EnableAllSubObjects);
        }
        return (Boolean)Options.EnableAllSubObjects.getDefault();
    }

    @Override
    public OptionsCache setXXFormatOptions(EnumSet<Options.XXFormatOptionValues> enumSet) {
        if (null == enumSet) {
            throw new IllegalArgumentException("XXFormatOptions Option value cannot be null");
        }
        this.addOptionToCache(Options.XXFormatOptions, enumSet);
        return this;
    }

    @Override
    public EnumSet<Options.XXFormatOptionValues> getXXFormatOptions() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.XXFormatOptions)) {
            return (EnumSet)this.m_cumulativeInfo.m_optionsCache.get(Options.XXFormatOptions);
        }
        return (EnumSet)Options.XXFormatOptions.getDefault();
    }

    @Override
    public OptionsCache setXMLDefinitionReference(XMLReference xMLReference) {
        if (null == xMLReference) {
            throw new IllegalArgumentException("XMLDefinitionReference Option value cannot be null");
        }
        this.addOptionToCache(Options.XMLDefinitionReference, xMLReference);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.XMLReferenceOption);
        return this;
    }

    @Override
    public XMLReference getXMLDefinitionReference() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.XMLDefinitionReference)) {
            return (XMLReference)this.m_cumulativeInfo.m_optionsCache.get(Options.XMLDefinitionReference);
        }
        return (XMLReference)Options.XMLDefinitionReference.getDefault();
    }

    @Override
    public OptionsCache setNullReplacementCharacter(int n) {
        this.addOptionToCache(Options.NullReplacementCharacter, n);
        return this;
    }

    @Override
    public int getNullReplacementCharacter() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.NullReplacementCharacter)) {
            return (Integer)this.m_cumulativeInfo.m_optionsCache.get(Options.NullReplacementCharacter);
        }
        return (Integer)Options.NullReplacementCharacter.getDefault();
    }

    @Override
    public OptionsCache setPageMLFlags(EnumSet<Options.PageMLFlagValues> enumSet) {
        if (null == enumSet) {
            throw new IllegalArgumentException("PageMLFlags Option value cannot be null");
        }
        this.addOptionToCache(Options.PageMLFlags, enumSet);
        return this;
    }

    @Override
    public EnumSet<Options.PageMLFlagValues> getPageMLFlags() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PageMLFlags)) {
            return (EnumSet)this.m_cumulativeInfo.m_optionsCache.get(Options.PageMLFlags);
        }
        return (EnumSet)Options.PageMLFlags.getDefault();
    }

    @Override
    public OptionsCache setPrinterName(String string) {
        this.addOptionToCache(Options.PrinterName, string);
        return this;
    }

    @Override
    public String getPrinterName() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PrinterName)) {
            return (String)this.m_cumulativeInfo.m_optionsCache.get(Options.PrinterName);
        }
        return (String)Options.PrinterName.getDefault();
    }

    @Override
    public OptionsCache setIncludeCharacterAttributes(EnumSet<Options.IncludeCharacterAttributeValues> enumSet) {
        if (null == enumSet) {
            throw new IllegalArgumentException("IncludeCharacterAttributes Option value cannot be null");
        }
        this.addOptionToCache(Options.IncludeCharacterAttributes, enumSet);
        return this;
    }

    @Override
    public EnumSet<Options.IncludeCharacterAttributeValues> getIncludeCharacterAttributes() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.IncludeCharacterAttributes)) {
            return (EnumSet)this.m_cumulativeInfo.m_optionsCache.get(Options.IncludeCharacterAttributes);
        }
        return (EnumSet)Options.IncludeCharacterAttributes.getDefault();
    }

    @Override
    public OptionsCache setSearchMLFlags(EnumSet<Options.SearchMLFlagValues> enumSet) {
        if (null == enumSet) {
            throw new IllegalArgumentException("SearchMLFlags Option value cannot be null");
        }
        this.addOptionToCache(Options.SearchMLFlags, enumSet);
        return this;
    }

    @Override
    public EnumSet<Options.SearchMLFlagValues> getSearchMLFlags() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.SearchMLFlags)) {
            return (EnumSet)this.m_cumulativeInfo.m_optionsCache.get(Options.SearchMLFlags);
        }
        return (EnumSet)Options.SearchMLFlags.getDefault();
    }

    @Override
    public OptionsCache setIncludeSearchMLOffset(boolean bl) {
        this.addOptionToCache(Options.IncludeSearchMLOffset, bl);
        return this;
    }

    @Override
    public boolean getIncludeSearchMLOffset() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.IncludeSearchMLOffset)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.IncludeSearchMLOffset);
        }
        return (Boolean)Options.IncludeSearchMLOffset.getDefault();
    }

    @Override
    public OptionsCache setSearchMLParaAttributes(EnumSet<Options.SearchMLParaAttributeValues> enumSet) {
        if (null == enumSet) {
            throw new IllegalArgumentException("SearchMLParaAttributes Option value cannot be null");
        }
        this.addOptionToCache(Options.SearchMLParaAttributes, enumSet);
        return this;
    }

    @Override
    public EnumSet<Options.SearchMLParaAttributeValues> getSearchMLParaAttributes() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.SearchMLParaAttributes)) {
            return (EnumSet)this.m_cumulativeInfo.m_optionsCache.get(Options.SearchMLParaAttributes);
        }
        return (EnumSet)Options.SearchMLParaAttributes.getDefault();
    }

    @Override
    public OptionsCache setUnmappedText(Options.UnmappedTextValue unmappedTextValue) {
        this.addOptionToCache(Options.UnmappedText, (Object)unmappedTextValue);
        return this;
    }

    @Override
    public Options.UnmappedTextValue getUnmappedText() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.UnmappedText)) {
            return (Options.UnmappedTextValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.UnmappedText));
        }
        return (Options.UnmappedTextValue)((Object)Options.UnmappedText.getDefault());
    }

    @Override
    public OptionsCache setSuppressFontAttributes(EnumSet<Options.SuppressFontAttributeValues> enumSet) {
        if (null == enumSet) {
            throw new IllegalArgumentException("SuppressFontAttributes Option value cannot be null");
        }
        this.addOptionToCache(Options.SuppressFontAttributes, enumSet);
        return this;
    }

    @Override
    public EnumSet<Options.SuppressFontAttributeValues> getSuppressFontAttributes() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.SuppressFontAttributes)) {
            return (EnumSet)this.m_cumulativeInfo.m_optionsCache.get(Options.SuppressFontAttributes);
        }
        return (EnumSet)Options.SuppressFontAttributes.getDefault();
    }

    @Override
    public OptionsCache setGenerateBulletsAndNumbering(boolean bl) {
        this.addOptionToCache(Options.GenerateBulletsAndNumbering, bl);
        return this;
    }

    @Override
    public boolean getGenerateBulletsAndNumbering() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GenerateBulletsAndNumbering)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.GenerateBulletsAndNumbering);
        }
        return (Boolean)Options.GenerateBulletsAndNumbering.getDefault();
    }

    @Override
    public OptionsCache setGridWrap(GridWrapInfo gridWrapInfo) {
        if (null == gridWrapInfo) {
            throw new IllegalArgumentException("GridWrap Option value cannot be null");
        }
        this.addOptionToCache(Options.GridWrap, gridWrapInfo);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.GridWrapOption);
        return this;
    }

    @Override
    public GridWrapInfo getGridWrap() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GridWrap)) {
            return (GridWrapInfo)this.m_cumulativeInfo.m_optionsCache.get(Options.GridWrap);
        }
        return (GridWrapInfo)Options.GridWrap.getDefault();
    }

    @Override
    public OptionsCache setGenerateJavascriptTabs(boolean bl) {
        this.addOptionToCache(Options.GenerateJavascriptTabs, bl);
        return this;
    }

    @Override
    public boolean getGenerateJavascriptTabs() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.GenerateJavascriptTabs)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.GenerateJavascriptTabs);
        }
        return (Boolean)Options.GenerateJavascriptTabs.getDefault();
    }

    @Override
    public OptionsCache setPreventGraphicOverlap(boolean bl) {
        this.addOptionToCache(Options.PreventGraphicOverlap, bl);
        return this;
    }

    @Override
    public boolean getPreventGraphicOverlap() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PreventGraphicOverlap)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.PreventGraphicOverlap);
        }
        return (Boolean)Options.PreventGraphicOverlap.getDefault();
    }

    @Override
    public OptionsCache setPageBreakLimit(long l) {
        this.addOptionToCache(Options.PageBreakLimit, l);
        return this;
    }

    @Override
    public long getPageBreakLimit() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PageBreakLimit)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.PageBreakLimit);
        }
        return (Long)Options.PageBreakLimit.getDefault();
    }

    @Override
    public OptionsCache setWebViewStructure(Options.WebViewStructureValue webViewStructureValue) {
        this.addOptionToCache(Options.WebViewStructure, (Object)webViewStructureValue);
        return this;
    }

    @Override
    public Options.WebViewStructureValue getWebViewStructure() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.WebViewStructure)) {
            return (Options.WebViewStructureValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.WebViewStructure));
        }
        return (Options.WebViewStructureValue)((Object)Options.WebViewStructure.getDefault());
    }

    @Override
    public OptionsCache setURLPathResources(String string) {
        this.addOptionToCache(Options.URLPathResources, string);
        return this;
    }

    @Override
    public String getURLPathResources() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.URLPathResources)) {
            return (String)this.m_cumulativeInfo.m_optionsCache.get(Options.URLPathResources);
        }
        return (String)Options.URLPathResources.getDefault();
    }

    @Override
    public OptionsCache setURLPathOutput(String string) {
        this.addOptionToCache(Options.URLPathOutput, string);
        return this;
    }

    @Override
    public String getURLPathOutput() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.URLPathOutput)) {
            return (String)this.m_cumulativeInfo.m_optionsCache.get(Options.URLPathOutput);
        }
        return (String)Options.URLPathOutput.getDefault();
    }

    @Override
    public OptionsCache setExternalStylesheets(List<String> list) {
        if (null == list) {
            return this;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : list) {
            linkedList.add(string);
        }
        this.addOptionToCache(Options.ExternalStylesheets, linkedList);
        return this;
    }

    @Override
    public List<String> getExternalStylesheets() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.ExternalStylesheets)) {
            List list = (List)this.m_cumulativeInfo.m_optionsCache.get(Options.ExternalStylesheets);
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string : list) {
                linkedList.add(string);
            }
            return linkedList;
        }
        return null;
    }

    @Override
    public OptionsCache setPostLibraryScripts(List<String> list) {
        if (null == list) {
            return this;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : list) {
            linkedList.add(string);
        }
        this.addOptionToCache(Options.PostLibraryScripts, linkedList);
        return this;
    }

    @Override
    public List<String> getPostLibraryScripts() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PostLibraryScripts)) {
            List list = (List)this.m_cumulativeInfo.m_optionsCache.get(Options.PostLibraryScripts);
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string : list) {
                linkedList.add(string);
            }
            return linkedList;
        }
        return null;
    }

    @Override
    public OptionsCache setPreLibraryScripts(List<String> list) {
        if (null == list) {
            return this;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : list) {
            linkedList.add(string);
        }
        this.addOptionToCache(Options.PreLibraryScripts, linkedList);
        return this;
    }

    @Override
    public List<String> getPreLibraryScripts() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PreLibraryScripts)) {
            List list = (List)this.m_cumulativeInfo.m_optionsCache.get(Options.PreLibraryScripts);
            LinkedList<String> linkedList = new LinkedList<String>();
            for (String string : list) {
                linkedList.add(string);
            }
            return linkedList;
        }
        return null;
    }

    @Override
    public OptionsCache setOutputRawtext(boolean bl) {
        this.addOptionToCache(Options.OutputRawtext, bl);
        return this;
    }

    @Override
    public boolean getOutputRawtext() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.OutputRawtext)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.OutputRawtext);
        }
        return (Boolean)Options.OutputRawtext.getDefault();
    }

    @Override
    public OptionsCache setFontBaseURL(String string) {
        this.addOptionToCache(Options.FontBaseURL, string);
        return this;
    }

    @Override
    public String getFontBaseURL() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.FontBaseURL)) {
            return (String)this.m_cumulativeInfo.m_optionsCache.get(Options.FontBaseURL);
        }
        return (String)Options.FontBaseURL.getDefault();
    }

    @Override
    public OptionsCache setWebFontPermissions(EnumSet<Options.WebFontPermissionValues> enumSet) {
        if (null == enumSet) {
            throw new IllegalArgumentException("WebFontPermissions Option value cannot be null");
        }
        this.addOptionToCache(Options.WebFontPermissions, enumSet);
        return this;
    }

    @Override
    public EnumSet<Options.WebFontPermissionValues> getWebFontPermissions() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.WebFontPermissions)) {
            return (EnumSet)this.m_cumulativeInfo.m_optionsCache.get(Options.WebFontPermissions);
        }
        return (EnumSet)Options.WebFontPermissions.getDefault();
    }

    @Override
    public OptionsCache setFontReferenceMethod(Options.FontReferenceMethodValue fontReferenceMethodValue) {
        this.addOptionToCache(Options.FontReferenceMethod, (Object)fontReferenceMethodValue);
        return this;
    }

    @Override
    public Options.FontReferenceMethodValue getFontReferenceMethod() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.FontReferenceMethod)) {
            return (Options.FontReferenceMethodValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.FontReferenceMethod));
        }
        return (Options.FontReferenceMethodValue)((Object)Options.FontReferenceMethod.getDefault());
    }

    @Override
    public OptionsCache setEmailAttachmentHandling(Options.EmailAttachmentHandlingValue emailAttachmentHandlingValue) {
        this.addOptionToCache(Options.EmailAttachmentHandling, (Object)emailAttachmentHandlingValue);
        return this;
    }

    @Override
    public Options.EmailAttachmentHandlingValue getEmailAttachmentHandling() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.EmailAttachmentHandling)) {
            return (Options.EmailAttachmentHandlingValue)((Object)this.m_cumulativeInfo.m_optionsCache.get(Options.EmailAttachmentHandling));
        }
        return (Options.EmailAttachmentHandlingValue)((Object)Options.EmailAttachmentHandling.getDefault());
    }

    @Override
    public OptionsCache setWebViewStylesheetName(String string) {
        this.addOptionToCache(Options.WebViewStylesheetName, string);
        return this;
    }

    @Override
    public String getWebViewStylesheetName() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.WebViewStylesheetName)) {
            return (String)this.m_cumulativeInfo.m_optionsCache.get(Options.WebViewStylesheetName);
        }
        return (String)Options.WebViewStylesheetName.getDefault();
    }

    @Override
    public OptionsCache setWebViewLibraryName(String string) {
        this.addOptionToCache(Options.WebViewLibraryName, string);
        return this;
    }

    @Override
    public String getWebViewLibraryName() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.WebViewLibraryName)) {
            return (String)this.m_cumulativeInfo.m_optionsCache.get(Options.WebViewLibraryName);
        }
        return (String)Options.WebViewLibraryName.getDefault();
    }

    @Override
    public OptionsCache setRawTextBufferSize(long l) {
        this.addOptionToCache(Options.RawTextBufferSize, l);
        return this;
    }

    @Override
    public long getRawTextBufferSize() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.RawTextBufferSize)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.RawTextBufferSize);
        }
        return (Long)Options.RawTextBufferSize.getDefault();
    }

    @Override
    public OptionsCache setVectorObjectLimit(long l) {
        this.addOptionToCache(Options.VectorObjectLimit, l);
        return this;
    }

    @Override
    public long getVectorObjectLimit() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.VectorObjectLimit)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.VectorObjectLimit);
        }
        return (Long)Options.VectorObjectLimit.getDefault();
    }

    @Override
    public OptionsCache setWrapSourceEMailFilesToFixedWidth(boolean bl) {
        this.addOptionToCache(Options.WrapSourceEMailFilesToFixedWidth, bl);
        return this;
    }

    @Override
    public boolean getWrapSourceEMailFilesToFixedWidth() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.WrapSourceEMailFilesToFixedWidth)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.WrapSourceEMailFilesToFixedWidth);
        }
        return (Boolean)Options.WrapSourceEMailFilesToFixedWidth.getDefault();
    }

    @Override
    public OptionsCache setFlagPageRedactionsEnabled(boolean bl) {
        this.addOptionToCache(Options.FlagPageRedactionsEnabled, bl);
        return this;
    }

    @Override
    public boolean getFlagPageRedactionsEnabled() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.FlagPageRedactionsEnabled)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.FlagPageRedactionsEnabled);
        }
        return (Boolean)Options.FlagPageRedactionsEnabled.getDefault();
    }

    @Override
    public OptionsCache setWrapSourceHTMLFilesToFixedWidth(boolean bl) {
        this.addOptionToCache(Options.WrapSourceHTMLFilesToFixedWidth, bl);
        return this;
    }

    @Override
    public boolean getWrapSourceHTMLFilesToFixedWidth() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.WrapSourceHTMLFilesToFixedWidth)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.WrapSourceHTMLFilesToFixedWidth);
        }
        return (Boolean)Options.WrapSourceHTMLFilesToFixedWidth.getDefault();
    }

    @Override
    public OptionsCache setPaginatePlainTextFiles(boolean bl) {
        this.addOptionToCache(Options.PaginatePlainTextFiles, bl);
        return this;
    }

    @Override
    public boolean getPaginatePlainTextFiles() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PaginatePlainTextFiles)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.PaginatePlainTextFiles);
        }
        return (Boolean)Options.PaginatePlainTextFiles.getDefault();
    }

    @Override
    public OptionsCache setWebviewJSONPageCount(long l) {
        this.addOptionToCache(Options.WebviewJSONPageCount, l);
        return this;
    }

    @Override
    public long getWebviewJSONPageCount() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.WebviewJSONPageCount)) {
            return (Long)this.m_cumulativeInfo.m_optionsCache.get(Options.WebviewJSONPageCount);
        }
        return (Long)Options.WebviewJSONPageCount.getDefault();
    }

    @Override
    public OptionsCache setTrackAnnotations(EnumSet<Options.TrackAnnotationsValues> enumSet) {
        if (null == enumSet) {
            throw new IllegalArgumentException("TrackAnnotations Option value cannot be null");
        }
        this.addOptionToCache(Options.TrackAnnotations, enumSet);
        return this;
    }

    @Override
    public EnumSet<Options.TrackAnnotationsValues> getTrackAnnotations() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.TrackAnnotations)) {
            return (EnumSet)this.m_cumulativeInfo.m_optionsCache.get(Options.TrackAnnotations);
        }
        return (EnumSet)Options.TrackAnnotations.getDefault();
    }

    @Override
    public OptionsCache setRedactionColor(ColorInfo colorInfo) {
        this.addOptionToCache(Options.RedactionColor, colorInfo);
        return this;
    }

    @Override
    public ColorInfo getRedactionColor() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.RedactionColor)) {
            return (ColorInfo)this.m_cumulativeInfo.m_optionsCache.get(Options.RedactionColor);
        }
        return (ColorInfo)Options.RedactionColor.getDefault();
    }

    @Override
    public OptionsCache setRedactionLabelsVisible(boolean bl) {
        this.addOptionToCache(Options.RedactionLabelsVisible, bl);
        return this;
    }

    @Override
    public boolean getRedactionLabelsVisible() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.RedactionLabelsVisible)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.RedactionLabelsVisible);
        }
        return (Boolean)Options.RedactionLabelsVisible.getDefault();
    }

    @Override
    public OptionsCache setRedactionLabelFont(FontInfo fontInfo) {
        if (null == fontInfo) {
            throw new IllegalArgumentException("RedactionLabelFont Option value cannot be null");
        }
        this.addOptionToCache(Options.RedactionLabelFont, fontInfo);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.RedactionLabelFontOption);
        return this;
    }

    @Override
    public FontInfo getRedactionLabelFont() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.RedactionLabelFont)) {
            return (FontInfo)this.m_cumulativeInfo.m_optionsCache.get(Options.RedactionLabelFont);
        }
        return (FontInfo)Options.RedactionLabelFont.getDefault();
    }

    @Override
    public OptionsCache setRedactionsEnabled(boolean bl) {
        this.addOptionToCache(Options.RedactionsEnabled, bl);
        return this;
    }

    @Override
    public boolean getRedactionsEnabled() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.RedactionsEnabled)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.RedactionsEnabled);
        }
        return (Boolean)Options.RedactionsEnabled.getDefault();
    }

    @Override
    public OptionsCache setMarginTextFont(FontInfo fontInfo) {
        if (null == fontInfo) {
            throw new IllegalArgumentException("MarginTextFont Option value cannot be null");
        }
        this.addOptionToCache(Options.MarginTextFont, fontInfo);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.MargintextFontOption);
        return this;
    }

    @Override
    public FontInfo getMarginTextFont() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.MarginTextFont)) {
            return (FontInfo)this.m_cumulativeInfo.m_optionsCache.get(Options.MarginTextFont);
        }
        return (FontInfo)Options.MarginTextFont.getDefault();
    }

    @Override
    public OptionsCache setMarginText(MarginText marginText) {
        if (null == marginText) {
            throw new IllegalArgumentException("MarginText Option value cannot be null");
        }
        this.addOptionToCache(Options.MarginText, marginText);
        this.setSpecialOptionFlag(Options.SpecialOptionFlag.MargintextOption);
        return this;
    }

    @Override
    public MarginText getMarginText() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.MarginText)) {
            return (MarginText)this.m_cumulativeInfo.m_optionsCache.get(Options.MarginText);
        }
        return (MarginText)Options.MarginText.getDefault();
    }

    @Override
    public OptionsCache setTimeZoneText(String string) {
        this.addOptionToCache(Options.TimeZoneText, string);
        return this;
    }

    @Override
    public String getTimeZoneText() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.TimeZoneText)) {
            return (String)this.m_cumulativeInfo.m_optionsCache.get(Options.TimeZoneText);
        }
        return (String)Options.TimeZoneText.getDefault();
    }

    @Override
    public OptionsCache setPrintTitleDisabled(boolean bl) {
        this.addOptionToCache(Options.PrintTitleDisabled, bl);
        return this;
    }

    @Override
    public boolean getPrintTitleDisabled() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.PrintTitleDisabled)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.PrintTitleDisabled);
        }
        return (Boolean)Options.PrintTitleDisabled.getDefault();
    }

    @Override
    public OptionsCache setHiddenTextFlag(boolean bl) {
        this.addOptionToCache(Options.HiddenTextFlag, bl);
        return this;
    }

    @Override
    public boolean getHiddenTextFlag() {
        if (this.m_cumulativeInfo.m_optionsCache.containsKey(Options.HiddenTextFlag)) {
            return (Boolean)this.m_cumulativeInfo.m_optionsCache.get(Options.HiddenTextFlag);
        }
        return (Boolean)Options.HiddenTextFlag.getDefault();
    }

    protected class SourceFileInfo {
        public File file;
        public SeekableByteChannel6ToBasicIO redirect;
        public Map<Options, Object> m_optionsCache = new HashMap<Options, Object>();
        public FileFormat format;
        EnumSet<Options.SpecialOptionFlag> specialOptionFlags = EnumSet.noneOf(Options.SpecialOptionFlag.class);
        public Callback callback = null;
        public boolean bOpenForNonSequentialAccess = false;
        public List<String> m_passwords = null;
        public String m_notesidfile = null;
        public int m_exportTimeout = 300000;
        public int m_documentOperationTimeout = 300000;
        public int m_processCreationTimeout = 10000;
        public Map<String, String> m_keyValuePairs = null;
        public List<OILinkMessages.Hilite> m_hilites = new LinkedList<OILinkMessages.Hilite>();
        public List<OILinkMessages.HiliteStampImage> m_stampimages;
        public List<RedactAnnotation> m_redactions = null;
        public List<String> m_highlightJsonDataList;

        public void inheritSourceFileInfo(SourceFileInfo sourceFileInfo) {
            for (Options options : sourceFileInfo.m_optionsCache.keySet()) {
                this.m_optionsCache.put(options, sourceFileInfo.m_optionsCache.get(options));
            }
            this.format = sourceFileInfo.format;
            this.specialOptionFlags.addAll(sourceFileInfo.specialOptionFlags);
            if (sourceFileInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.CallbackOption)) {
                this.callback = sourceFileInfo.callback;
            }
            if (sourceFileInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.OpenForNonSequentialAccessOption)) {
                this.bOpenForNonSequentialAccess = sourceFileInfo.bOpenForNonSequentialAccess;
            }
            if (sourceFileInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.PasswordsOption)) {
                if (null == sourceFileInfo.m_passwords) {
                    this.m_passwords = null;
                } else {
                    this.m_passwords = new LinkedList<String>();
                    this.m_passwords.addAll(sourceFileInfo.m_passwords);
                }
            }
            if (sourceFileInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.LotusNotesIdOption)) {
                this.m_notesidfile = sourceFileInfo.m_notesidfile;
            }
            if (sourceFileInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.ExportTimeoutOption)) {
                this.m_exportTimeout = sourceFileInfo.m_exportTimeout;
            }
            if (sourceFileInfo.specialOptionFlags.contains((Object)Options.SpecialOptionFlag.KeyValuePairsOption)) {
                if (null == sourceFileInfo.m_keyValuePairs) {
                    this.m_keyValuePairs = null;
                } else {
                    if (null == this.m_keyValuePairs) {
                        this.m_keyValuePairs = new HashMap<String, String>();
                    }
                    this.m_keyValuePairs.putAll(sourceFileInfo.m_keyValuePairs);
                }
            }
        }
    }
}

