/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein.options;

import com.oracle.outsidein.ColorInfo;
import com.oracle.outsidein.OutsideInException;
import com.oracle.outsidein.options.FontAliases;
import com.oracle.outsidein.options.FontInfo;
import com.oracle.outsidein.options.FontList;
import com.oracle.outsidein.options.GridWrapInfo;
import com.oracle.outsidein.options.MailHeaders;
import com.oracle.outsidein.options.MarginText;
import com.oracle.outsidein.options.Margins;
import com.oracle.outsidein.options.Option;
import com.oracle.outsidein.options.OptionImpl;
import com.oracle.outsidein.options.OptionsCache;
import com.oracle.outsidein.options.OptionsCacheImpl;
import com.oracle.outsidein.options.PageInfo;
import com.oracle.outsidein.options.PageRange;
import com.oracle.outsidein.options.Watermark;
import com.oracle.outsidein.options.XMLReference;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import net.bitform.oilink.OIHandle;
import net.bitform.oilink.OILink;

public enum Options implements OptionImpl
{
    DefaultInputCharacterSet("DefaultInputCharacterSet", "Default Input Character Set", (Object)((Object)DefaultInputCharacterSetValue.SYSTEMDEFAULT), OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)DefaultInputCharacterSetValue.class){
        private final int SCCOPT_DEFAULTINPUTCHARSET = 342980;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 342980, ((DefaultInputCharacterSetValue)((Object)object)).value);
        }
    }
    ,
    UnmappableCharacter("UnmappableCharacter", "Unmappable Character", (Object)42, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)Integer.class, null){
        private final int SCCOPT_UNMAPPABLECHAR = 98;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 98, (Integer)object);
        }
    }
    ,
    UnicodeByteOrder("UnicodeByteOrder", "This option determines the byte order of Unicode characters in the output files when Unicode is chosen as the output character set.", (Object)((Object)UnicodeByteOrderValue.FROMTEMPLATE), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)UnicodeByteOrderValue.class){
        private final int SCCOPT_EX_CHARBYTEORDER = 31;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 31, ((UnicodeByteOrderValue)((Object)object)).value);
        }
    }
    ,
    OutputCharacterSet("OutputCharacterSet", "Character set to be used in output file", (Object)((Object)OutputCharacterSetValue.WINDOWS1252), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)OutputCharacterSetValue.class){
        private final int SCCOPT_EX_OUTPUTCHARACTERSET = 1;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 1, ((OutputCharacterSetValue)((Object)object)).value);
        }
    }
    ,
    InternalRendering("InternalRendering", "attempt to use its internal graphics code to render fonts and graphics.", (Object)false, OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.SEARCHEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_RENDERING_PREFER_OIT = 338501;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338501, (Boolean)object);
        }
    }
    ,
    EnableAlphaBlending("EnableAlphaBlending", "enable alpha-channel blending (transparency) in rendering vector images when using an X-Windows output solution", (Object)false, OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCID_RENDER_ENABLEALPHABLENDING = 338503;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338503, (Boolean)object);
        }
    }
    ,
    OutputChangeTracking("OutputChangeTracking", "Option to output change tracking information.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EX_CHANGETRACKING = 96;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 96, (Boolean)object);
        }
    }
    ,
    CollapseWhiteSpace("CollapseWhiteSpace", "Option to delete whitespace from Output document.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EX_COLLAPSEWHITESPACE = 51;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 51, (Boolean)object);
        }
    }
    ,
    ExtractEmbeddedFiles("ExtractEmbeddedFiles", "Option to control extraction of attached documents", (Object)((Object)ExtractEmbeddedFilesValue.OFF), OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)ExtractEmbeddedFilesValue.class){
        private final int SCCOPT_EX_EXTRACTEMBEDDEDFILES = 94;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 94, ((ExtractEmbeddedFilesValue)((Object)object)).value);
        }
    }
    ,
    HTMLFlavor("HTMLFlavor", "Option to tailor the html output to a specific browser", (Object)((Object)HTMLFlavorValue.HTML40), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)HTMLFlavorValue.class){
        private final int SCCOPT_EX_FLAVOR = 7;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 7, ((HTMLFlavorValue)((Object)object)).value);
        }
    }
    ,
    HTMLOutputFormatting("HTMLOutputFormatting", "Option to turn off writing characters to make output more readable.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EX_NOSOURCEFORMATTING = 33;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 33, (Boolean)object);
        }
    }
    ,
    ShowHiddenText("ShowHiddenText", "Option to output hidden text.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EX_SHOWHIDDENTEXT = 79;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 79, (Boolean)object);
        }
    }
    ,
    SimpleStyleNames("SimpleStyleNames", "Option to generate names that may not be unique, but are easy to read.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EX_SIMPLESTYLENAMES = 36;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 36, (Boolean)object);
        }
    }
    ,
    ShowHiddenSpreadSheetData("ShowHiddenSpreadSheetData", "Option to output hidden rows, columns and sheets in spreadsheets.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EX_SHOWHIDDENSSDATA = 95;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 95, (Boolean)object);
        }
    }
    ,
    FallbackFormat("FallbackFormat", "Option to control how unknown files are handled", (Object)((Object)FallbackFormatValue.TEXT), OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)FallbackFormatValue.class){
        private final int SCCOPT_FALLBACKFORMAT = 2;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 2, ((FallbackFormatValue)((Object)object)).value);
        }
    }
    ,
    ExtractXMPMetadata("ExtractXMPMetadata", "Option to extract XMP metadata as raw XMP data from filter.", (Object)false, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT, Option.OutsideInProducts.XMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EXTRACTXMPMETADATA = 127;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 127, (Boolean)object);
        }
    }
    ,
    ParseXMPMetadata("ParseXMPMetadata", "Option to parse XMP metadata from filter.", (Object)false, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_PARSEXMPMETADATA = 338786;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338786, (Boolean)object);
        }
    }
    ,
    PerformExtendedFI("PerformExtendedFI", " This option affects how an input file's internal format (application type) is identified when the file is first opened by the Oracle Outside In technology. When the extended test flag is in effect, and an input file is identified as being either 7-bit ASCII, EBCDIC, or Unicode, the file's contents will be interpreted as such by the export process. The extended test is optional because it requires extra processing and cannot guarantee complete accuracy (which would require the inspection of every single byte in a file to eliminate false positives.)", (Object)true, OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)Boolean.class, null){
        private final int SCCOPT_FIFLAGS = 338486;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338486, (Boolean)object != false ? PerformExtendedFIValue.FIEXTENDEDTEST.value : PerformExtendedFIValue.FINORMAL.value);
        }
    }
    ,
    LotusNotesDirectory("LotusNotesDirectory", "Path to the Lotus Notes Installation", (Object)null, OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)String.class){
        private final int SCCOPT_LOTUSNOTUSDIRECTORY = 132;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 132, (String)object);
        }
    }
    ,
    PDFReorderBiDi("PDFReorderBiDi", " This option controls whether or not the PDF filter will attempt to reorder bidirectional text runs so that the output is in standard logical order as used by the Unicode 2.0 and later specification. This additional processing will result in slower filter performance according to the amount of bidirectional data in the file.", (Object)((Object)PDFReorderBiDiValue.STANDARDBIDI), OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)PDFReorderBiDiValue.class){
        private final int SCCOPT_PDF_FILTER_REORDER_BIDI = 338791;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338791, ((PDFReorderBiDiValue)((Object)object)).value);
        }
    }
    ,
    PDFDetectBiDiBit("PDFDetectBiDiBit", " This option controls BIDI Lifebit-scan in a PDF file.", (Object)((Object)PDFBiDiDetectValue.STANDARD), OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)PDFBiDiDetectValue.class){
        private final int SCCOPT_BIDILIFEBIT = 338799;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338799, ((PDFBiDiDetectValue)((Object)object)).value);
        }
    }
    ,
    PDFWordSpacingFactor("PDFWordSpacingFactor", "Option to specify the spacing threshold to detect word breaks in PDF documents", (Object)Float.valueOf(0.85f), OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)Float.class){
        private final int SCCOPT_PDF_FILTER_WORD_DELIM_FRACTION = 338795;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338795, ((Float)object).floatValue());
        }
    }
    ,
    PDFInputMaxEmbeddedObjects("PDFInputMaxEmbeddedObjects", "Option to specify the maximum number of embedded objects that will be output by the PDF filter.", (Object)0L, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)Long.class){
        private final int SCCID_PDF_FILTER_MAX_EMBEDDED_OBJECTS = 338796;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338796, (Long)object);
        }
    }
    ,
    PDFInputMaxVectorPaths("PDFInputMaxVectorPaths", "Option to specify the maximum number of vector path drawings that will be output by the PDF filter.", (Object)0L, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)Long.class){
        private final int SCCID_PDF_FILTER_MAX_VECTOR_PATHS = 338797;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338797, (Long)object);
        }
    }
    ,
    TimeZoneOffset("TimeZoneOffset", "Option to specify the time zone offset from GMT to display times in", (Object)0L, OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)Long.class){
        private final int SCCOPT_TIMEZONE = 338691;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338691, (Long)object);
        }
    }
    ,
    ISODateTimes("ISODateTimes", "Option to have Date and Time values converted to the ISO 8601 standard", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.allOf(Option.OutsideInProducts.class), SpecialOptionFlag.FormatFlagsOption, Boolean.class, null),
    StrictFile("StrictFile", "Option to prevent opening embedded files from non-fully qualified path or URL", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.SEARCHEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), SpecialOptionFlag.FormatFlagsOption, Boolean.class, null),
    IgnorePassword("IgnorePassword", "Option to disable the password verification of files where the contents can be processed without validation of the password.", (Object)false, OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)Boolean.class, null){
        private final int SCCOPT_IGNORE_PASSWORD = 273253;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 273253, (Boolean)object);
        }
    }
    ,
    BiDiReorderMethod("BiDiReorderMethod", "option to control how the technology reorders bidirectional text", (Object)((Object)BiDiReorderMethodValue.UNICODEOFF), OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)BiDiReorderMethodValue.class){
        private final int SCCOPT_REORDERMETHOD = 338731;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338731, ((BiDiReorderMethodValue)((Object)object)).value);
        }
    }
    ,
    IECondCommentMode("IECondCommentMode", "Option to control special types of comment that will be read by particular versions of browsers or other products.", (Object)EnumSet.of(IECondCommentFlagValues.NONE), OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)EnumSet.class, new Class[]{IECondCommentFlagValues.class}){
        private final int SCCOPT_HTML_COND_COMMENT_MODE = 338792;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            long l = 0L;
            for (IECondCommentFlagValues iECondCommentFlagValues : (EnumSet)object) {
                l |= iECondCommentFlagValues.value;
            }
            oILink.DASetOption(oIHandle, 338792, l);
        }
    }
    ,
    ShowArchiveFullPath("ShowArchiveFullPath", " This option tells the archive display engine to show the full path to a node in response to a GetRecordInfo message. ", (Object)false, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)Boolean.class, null){
        private final int SCCOPT_ARCFULLPATH = 338589;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338589, (Boolean)object);
        }
    }
    ,
    GenerateExcelRevisions("GenerateExcelRevisions", "This option controls extraction of tracked changes from Excel files.", (Object)false, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_GENERATEEXCELREVISIONS = 273265;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 273265, (Boolean)object);
        }
    }
    ,
    ProcessOLEEmbeddingMode("ProcessOLEEmbeddingMode", "Option to control which embeddings are to be processed as native (OLE) documents and which are processed using the alternate graphic in Powerpoint '97-2003 files.", (Object)((Object)ProcessOLEEmbeddingModeValue.STANDARD), OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT, Option.OutsideInProducts.XMLEXPORT), null, (Class)ProcessOLEEmbeddingModeValue.class){
        private final int SCCOPT_PROCESS_OLE_EMBEDDINGS = 133;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 133, ((ProcessOLEEmbeddingModeValue)((Object)object)).value);
        }
    }
    ,
    DropPDFHyphens("DropPDFHyphens", "This option controls whether or not the PDF filter will drop hyphens at the end of a line.", (Object)false, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_PDF_FILTER_DROPHYPHENS = 338793;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338793, (Boolean)object);
        }
    }
    ,
    ApplyZLIBCompression("ApplyZLIBCompression", "option to apply ZLIB compression to fonts and raster graphics while generating a PDF output file", (Object)true, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_APPLYFILTER = 87541;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 87541, (Boolean)object);
        }
    }
    ,
    InterlacedGIFs("InterlacedGIFs", "Option to enable creation of Interlaced GIFs", (Object)true, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_GIF_INTERLACED = 17;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 17, (Boolean)object);
        }
    }
    ,
    CropToContent("CropToContent", "option to enable cropping to content", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_GRAPHIC_CROPPING = 104;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 104, (Boolean)object != false ? CropToContentValue.CROPTOCONTENT.value : CropToContentValue.NOCROPPING.value);
        }
    }
    ,
    GraphicHeight("GraphicHeight", "Absolute height in pixels for exported images", (Object)0L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Long.class){
        private final int SCCOPT_GRAPHIC_HEIGHT = 5;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 5, (Long)object);
        }
    }
    ,
    GraphicHeightLimit("GraphicHeightLimit", "Graphic height limit in pixels for exported images", (Object)0L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Long.class){
        private final int SCCOPT_GRAPHIC_HEIGHTLIMIT = 40;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 40, (Long)object);
        }
    }
    ,
    GraphicOutputDPI("GraphicOutputDPI", "Output DPI for exported images", (Object)96L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Long.class){
        private final int SCCOPT_GRAPHIC_OUTPUTDPI = 34;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 34, (Long)object);
        }
    }
    ,
    GraphicSizeLimit("GraphicSizeLimit", "Graphic size limit in pixels for exported images", (Object)0L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Long.class){
        private final int SCCOPT_GRAPHIC_SIZELIMIT = 38;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 38, (Long)object);
        }
    }
    ,
    TransparencyColor("TransparencyColor", "Transparency Color", (Object)new ColorInfo(), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)ColorInfo.class){
        private final int SCCOPT_GRAPHIC_TRANSPARENCYCOLOR = 103;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 103, ((ColorInfo)object).getOptionValue());
        }
    }
    ,
    GraphicWidth("GraphicWidth", "Absolute width in pixels for exported images", (Object)0L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Long.class){
        private final int SCCOPT_GRAPHIC_WIDTH = 4;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 4, (Long)object);
        }
    }
    ,
    GraphicWidthLimit("GraphicWidthLimit", "Graphic width limit in pixels for exported images", (Object)0L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Long.class){
        private final int SCCOPT_GRAPHIC_WIDTHLIMIT = 39;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 39, (Long)object);
        }
    }
    ,
    GraphicRenderAsPage("GraphicRenderAsPage", "Option to fit the image to the size of the page.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_GRAPHIC_RENDERASPAGE = 128;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 128, (Boolean)object);
        }
    }
    ,
    GraphicSizeMethod("GraphicSizeMethod", " This option allows the user to specify the output graphics device's resolution in DPI and only applies to images whose size is specified in physical units (in/cm). For example, consider a 1\" square, 100 DPI graphic that is to be rendered on a 50 DPI device (GraphicOutputDPI is set to 50). In this case, the size of the resulting TIFF, BMP, JPEG, GIF, or PNG will be 50 x 50 pixels._PARA_ In addition, setting this option to 0(Maintain Source Image DPI), can be used to suppress any dimensional changes to an image. In other words, a 1\" square, 100 DPI graphic will be converted to an image that is 100 x 100 pixels in size. This value indicates that the DPI of the output device is not important. It extracts the maximum resolution from the input image with the smallest exported image size._PARA_ Setting this option to 0 may result in the creation of extremely large images. Be aware that there may be limitations in the system running this technology that could result in undesirably large bandwidth consumption or an error message. Additionally, an out of memory error message will be generated if system memory is insufficient to handle a particularly large image._PARA_ Also note that setting this option to 0 will force the technology to use the DPI settings already present in raster images, but will use the current screen resolution as the DPI setting for any other type of input file._PARA_ For some output graphic types, there may be a discrepancy between the value set by this option and the DPI value reported by some graphics applications. The discrepancy occurs when the output format uses metric units (DPM, or dots per meter) instead of English units (DPI, or dots per inch). Depending on how the graphics application performs rounding on meters to inches conversions, the DPI value reported may be 1 unit more than expected. An example of a format which may exhibit this problem is PNG. The maximum value that can be set is 2400 DPI.", (Object)((Object)GraphicSizeMethodValue.SMOOTHSIZING), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)GraphicSizeMethodValue.class){
        private final int SCCOPT_GRAPHIC_SIZEMETHOD = 30;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 30, ((GraphicSizeMethodValue)((Object)object)).value);
        }
    }
    ,
    TIFFColorSpace("TIFFColorSpace", "", (Object)((Object)TIFFColorSpaceValue.RGB24BIT), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.TiffOptions, TIFFColorSpaceValue.class),
    TIFFCompression("TIFFCompression", "", (Object)((Object)TIFFCompressionValue.PACKBITS), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.TiffOptions, TIFFCompressionValue.class),
    TIFFMultiPage("TIFFMultiPage", "Option to generate multipage TIFF Files.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.TiffOptions, Boolean.class, null),
    TIFFByteOrder("TIFFByteOrder", "Option to set the byte order used within the output file when exporting to the TIFF destination file format.", (Object)((Object)TIFFByteOrderValue.LITTLEENDIAN), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.TiffOptions, TIFFByteOrderValue.class),
    TIFFFillOrder("TIFFFillOrder", "", (Object)((Object)TIFFFillOrderValue.FILESTORE), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.TiffOptions, TIFFFillOrderValue.class),
    JPEGQuality("JPEGQuality", "Quality of the JPEG on a scale of 1-100 where 100 is the best (no lossyness)", (Object)100L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Long.class){
        private final int SCCOPT_JPEG_QUALITY = 18;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 18, (Long)object);
        }
    }
    ,
    QuickThumbnail("QuickThumbnail", "Option to render scaled images with a focus on speed and reduced overall memory usage.", (Object)true, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_QUICKTHUMBNAIL = 130;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 130, (Boolean)object);
        }
    }
    ,
    ImagePassthrough("ImagePassthrough", "Option to allow certain files to circumvent the normal filtering process.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_IMAGE_PASSTHROUGH = 87547;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 87547, (Boolean)object);
        }
    }
    ,
    AcceptAlternateGraphics("AcceptAlternateGraphics", "Option to extract GIF,JPEG and PNG embeddings rather than converting them.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.XMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_ACCEPT_ALT_GRAPHICS = 93;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 93, (Boolean)object);
        }
    }
    ,
    OutputGraphicType("OutputGraphicType", "Option to control which graphics are generated.", (Object)null, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.XMLEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)OutputGraphicTypeValue.class){
        private final int SCCOPT_GRAPHIC_TYPE = 6;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 6, ((OutputGraphicTypeValue)((Object)object)).value);
        }
    }
    ,
    DetectGrayScaleAsColor("DetectGrayScaleAsColor", "Option to export grayscale content to color JPEGs or not.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_GRAYSCALE_TO_COLOR = 129;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 129, (Boolean)object);
        }
    }
    ,
    PageFitMode("PageFitMode", "Option to scale a database file to a certain percent or to a page width or height", (Object)((Object)PageFitModeValue.FITTOPAGES), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.PrintFitModeOption, PageFitModeValue.class),
    RenderGridlines("RenderGridlines", "Option to generate lines between cells in the rendered images", (Object)true, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.RenderGridlineOption, Boolean.class, null),
    RenderHeadings("RenderHeadings", "Option to print headings in the rendered images", (Object)true, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.RenderHeadingsOption, Boolean.class, null),
    GridMaxPageHeight("GridMaxPageHeight", "option to change the height of a page to match the scaled size of the page being rendered - within limits", (Object)0L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Long.class){
        private final int SCCOPT_MAXSSDBPAGEHEIGHT = 101;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 101, (Long)object);
        }
    }
    ,
    GridMaxPageWidth("GridMaxPageWidth", "option to change the width of a page to match the scaled size of the page being rendered - within limits", (Object)0L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Long.class){
        private final int SCCOPT_MAXSSDBPAGEWIDTH = 100;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 100, (Long)object);
        }
    }
    ,
    PageDirection("PageDirection", "Option to control the pattern in which the pages are rendered, either across first and then down, or down first and then across", (Object)((Object)PageDirectionValue.DOWN), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)PageDirectionValue.class){
        private final int SCCOPT_SSPRINTDIRECTION = 338192;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338192, ((PageDirectionValue)((Object)object)).value);
        }
    }
    ,
    PageScalePercent("PageScalePercent", "Option to scale spreadsheet", (Object)100L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Long.class){
        private final int SCCOPT_SSPRINTSCALEPERCENT = 338189;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338189, (Long)object);
        }
    }
    ,
    FitHeightToPages("FitHeightToPages", "Option to specify number of vertical pages", (Object)1L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Long.class){
        private final int SCCOPT_SSPRINTSCALEXHIGH = 338190;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338190, (Long)object);
        }
    }
    ,
    FitWidthToPages("FitWidthToPages", "Option to specify number of horizontal pages", (Object)1L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Long.class){
        private final int SCCOPT_SSPRINTSCALEXWIDE = 338191;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338191, (Long)object);
        }
    }
    ,
    ShowHiddenCells("ShowHiddenCells", "Option to show hidden cells in Spreadsheets", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_SSSHOWHIDDENCELLS = 338195;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338195, (Boolean)object);
        }
    }
    ,
    ShowColumnHeadings("ShowColumnHeadings", "Option to show column headings in spreadhseet and database files", (Object)true, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EX_SSDBROWCOLHEADINGS = 106;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 106, (Boolean)object);
        }
    }
    ,
    BorderMode("BorderMode", "Option to determines how borders will be handled for spreadsheet and databasefiles.", (Object)((Object)BorderModeValue.CREATEIFMISSING), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)BorderModeValue.class){
        private final int SCCOPT_EX_SSDBBORDERS = 107;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 107, ((BorderModeValue)((Object)object)).value);
        }
    }
    ,
    SuppressEmptyCells("SuppressEmptyCells", "Option to suppress blank cells to the right and bottom of the last data cell.", (Object)false, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCID_FILTERNOBLANK = 273248;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 273248, (Boolean)object);
        }
    }
    ,
    DefaultPageSize("DefaultPageSize", "Default Page Size", new PageInfo(PageInfo.PageSizeUnitsValue.INCHES, 11.0f, 8.5f), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT), SpecialOptionFlag.DefaultPageSizeOption, PageInfo.class),
    DefaultPageMargins("DefaultPageMargins", "Default Page Margins", new Margins(1440L, 1440L, 1440L, 1440L), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.DefaultPrintMarginOption, Margins.class),
    UseDocumentPageSettings("UseDocumentPageSettings", "Option to use the document's page layout information when rendering", (Object)true, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_USEDOCPAGESETTINGS = 337794;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 337794, (Boolean)object);
        }
    }
    ,
    PageRange("PageRange", "Print Range", new PageRange(), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.PrintRangeOption, PageRange.class),
    LinearizePDFOutput("LinearizePDFOutput", "Option to produce linearized PDF Files", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_DOLINEARIZATION = 87543;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 87543, (Boolean)object);
        }
    }
    ,
    EmailHeaders("EmailHeaders", "Customized Mime Headers", new MailHeaders(MailHeaders.BaselineValue.STANDARD), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.HTMLEXPORT), SpecialOptionFlag.MailHeadersOption, MailHeaders.class),
    AppendEmailAttachments("AppendEmailAttachments", "Option to output email attachments as PDF Files", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EXPORTEMAILATTACHMENTS = 87546;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 87546, (Boolean)object);
        }
    }
    ,
    StrokeOutText("StrokeOutText", "Option to stroke out (display as graphical primitives) text in an AutoCAD file.", (Object)true, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_STROKE_TEXT = 138;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 138, (Boolean)object);
        }
    }
    ,
    RenderEmbeddedFonts("RenderEmbeddedFonts", "Option to disable the use of embedded fonts in PDF input files.", (Object)true, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_RENDER_EMBEDDED_FONTS = 87549;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 87549, (Boolean)object);
        }
    }
    ,
    DefaultRenderFont("DefaultRenderFont", "Default Render Font", null, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.HTMLEXPORT), SpecialOptionFlag.DefaultPrintFontOption, FontInfo.class),
    FontAliasList("FontAliasList", "Option to set font aliases", new FontAliases(true, null), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.HTMLEXPORT), SpecialOptionFlag.FontAliasOption, FontAliases.class),
    EmbedFonts("EmbedFonts", "This option determines whether or not to automatically embed Adobe Standard Base 14 fonts.", (Object)((Object)EmbedFontsValue.REDUCESIZE), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.PDFEXPORT), SpecialOptionFlag.EmbedFontsOption, EmbedFontsValue.class),
    FontDirectories("FontDirectories", "option to specify one or more font directories where fonts are located for use by PDF Export.", null, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT, Option.OutsideInProducts.HTMLEXPORT), SpecialOptionFlag.FontDirectoriesOption, List.class, new Class[]{File.class}),
    FontFilter("FontFilter", "This option allows the developer to specify a list of fonts to be included or excluded during the export process", null, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT), SpecialOptionFlag.FontFilterOption, FontList.class),
    Watermark("Watermark", "Watermarks", new Watermark(), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.WatermarkOption, Watermark.class),
    TempDirectory("TempDirectory", "Option to control where temporary files are created", (Object)null, OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)String.class){
        private final int SCCOPT_TEMPDIR = 338487;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338487, (String)object);
        }
    }
    ,
    DocumentMemoryMode("DocumentMemoryMode", "Option to control maximum amount of memory that the technology may use to store the document's data.", (Object)((Object)DocumentMemoryModeValue.SMALL), OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)DocumentMemoryModeValue.class){
        private final int SCCOPT_DOCUMENTMEMORYMODE = 338490;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338490, ((DocumentMemoryModeValue)((Object)object)).value);
        }
    }
    ,
    ExportPerformanceMode("ExportPerformanceMode", "Option to skip processing the style information when possible for better performance.", (Object)((Object)ExportPerformanceModeValue.NORMAL), OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT), null, (Class)ExportPerformanceModeValue.class){
        private final int SCCOPT_EX_PERFORMANCEMODE = 137;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 137, ((ExportPerformanceModeValue)((Object)object)).value);
        }
    }
    ,
    EnableAllSubObjects("EnableAllSubObjects", "Option to enable Oracle's Internal Optimization", (Object)false, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_ENABLEALLSUBOBJECTS = 338785;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338785, (Boolean)object != false ? EnableSubObjectsValue.NORMALSUBOBJECTS.value : EnableSubObjectsValue.ENABLEALLSUBOBJECTS.value);
        }
    }
    ,
    XXFormatOptions("XXFormatOptions", "Various Options to control XX output", (Object)EnumSet.of(XXFormatOptionValues.REMOVEFONTGROUPS), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.XMLEXPORT), null, (Class)EnumSet.class, new Class[]{XXFormatOptionValues.class}){
        private final int SCCOPT_CCFLEX_FORMATOPTIONS = 99;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            long l = 0L;
            for (XXFormatOptionValues xXFormatOptionValues : (EnumSet)object) {
                l |= xXFormatOptionValues.value;
            }
            oILink.DASetOption(oIHandle, 99, l);
        }
    }
    ,
    XMLDefinitionReference("XMLDefinitionReference", "This option determines whether Flexiondoc will reference a SearchML or PageML schema, DTD, or no reference when generating output.", null, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT, Option.OutsideInProducts.XMLEXPORT), SpecialOptionFlag.XMLReferenceOption, XMLReference.class),
    NullReplacementCharacter("NullReplacementCharacter", "This option specifies the character that will be used to replace null characters if null path separators are being used.", (Object)47, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT), null, (Class)Integer.class, null){
        private final int SCCOPT_XML_NULLREPLACECHAR = 102;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 102, (Integer)object);
        }
    }
    ,
    PageMLFlags("PageMLFlags", "Various Options to control PageML output", (Object)EnumSet.noneOf(PageMLFlagValues.class), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT), null, (Class)EnumSet.class, new Class[]{PageMLFlagValues.class}){
        private final int SCCOPT_XML_PAGEML_FLAGS = 64;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            long l = 0L;
            for (PageMLFlagValues pageMLFlagValues : (EnumSet)object) {
                l |= pageMLFlagValues.value;
            }
            oILink.DASetOption(oIHandle, 64, l);
        }
    }
    ,
    PrinterName("PrinterName", "This option allows the developer to set a particular printer whose device context is used to render pages.", (Object)null, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT), null, (Class)String.class){
        private final int SCCOPT_XML_PAGEML_PRINTERNAME = 74;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 74, (String)object);
        }
    }
    ,
    IncludeCharacterAttributes("IncludeCharacterAttributes", "Character Attributes to track", (Object)EnumSet.noneOf(IncludeCharacterAttributeValues.class), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT), null, (Class)EnumSet.class, new Class[]{IncludeCharacterAttributeValues.class}){
        private final int SCCOPT_XML_SEARCHML_CHAR_ATTRS = 75;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            long l = 0L;
            for (IncludeCharacterAttributeValues includeCharacterAttributeValues : (EnumSet)object) {
                l |= includeCharacterAttributeValues.value;
            }
            oILink.DASetOption(oIHandle, 75, l);
        }
    }
    ,
    SearchMLFlags("SearchMLFlags", "Various Options to control SearchML output", (Object)EnumSet.noneOf(SearchMLFlagValues.class), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT), null, (Class)EnumSet.class, new Class[]{SearchMLFlagValues.class}){
        private final int SCCOPT_XML_SEARCHML_FLAGS = 63;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            long l = 0L;
            for (SearchMLFlagValues searchMLFlagValues : (EnumSet)object) {
                l |= searchMLFlagValues.value;
            }
            oILink.DASetOption(oIHandle, 63, l);
        }
    }
    ,
    IncludeSearchMLOffset("IncludeSearchMLOffset", "Option to include offset information in SearchML", (Object)false, OptionImpl.OptionScopeValue.INPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_XML_SEARCHML_OFFSET = 77;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 77, (Boolean)object);
        }
    }
    ,
    SearchMLParaAttributes("SearchMLParaAttributes", "Various Options to control SearchML output related to paragraph attributes", (Object)EnumSet.noneOf(SearchMLParaAttributeValues.class), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT), null, (Class)EnumSet.class, new Class[]{SearchMLParaAttributeValues.class}){
        private final int SCCOPT_XML_SEARCHML_PARA_ATTRS = 76;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            long l = 0L;
            for (SearchMLParaAttributeValues searchMLParaAttributeValues : (EnumSet)object) {
                l |= searchMLParaAttributeValues.value;
            }
            oILink.DASetOption(oIHandle, 76, l);
        }
    }
    ,
    UnmappedText("UnmappedText", "This option allows for the production of unmapped text (the original code points from the input document).", (Object)((Object)UnmappedTextValue.NOUNMAPPEDTEXT), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.SEARCHEXPORT), null, (Class)UnmappedTextValue.class){
        private final int SCCOPT_XML_SEARCHML_UNMAPPEDTEXT = 109;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 109, ((UnmappedTextValue)((Object)object)).value);
        }
    }
    ,
    SuppressFontAttributes("SuppressFontAttributes", "This option is used to turn off specified font-related markup in the output.", (Object)EnumSet.noneOf(SuppressFontAttributeValues.class), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)EnumSet.class, new Class[]{SuppressFontAttributeValues.class}){
        private final int SCCOPT_EX_FONTFLAGS = 60;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            long l = 0L;
            for (SuppressFontAttributeValues suppressFontAttributeValues : (EnumSet)object) {
                l |= suppressFontAttributeValues.value;
            }
            oILink.DASetOption(oIHandle, 60, l);
        }
    }
    ,
    GenerateBulletsAndNumbering("GenerateBulletsAndNumbering", "Option to generate list numbers and/or bullets as needed rather than using list markup tags.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EX_GENBULLETSANDNUMS = 41;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 41, (Boolean)object);
        }
    }
    ,
    GridWrap("GridWrap", "HX Grid wrap Handling", new GridWrapInfo(true, 5000L, 100L, GridWrapInfo.AdvanceModeValue.DOWN), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), SpecialOptionFlag.GridWrapOption, GridWrapInfo.class),
    GenerateJavascriptTabs("GenerateJavascriptTabs", "Option to support tabs using JavaScript to calculate tab stops and position blocks of text accordingly", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EX_JAVASCRIPTTABS = 49;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 49, (Boolean)object);
        }
    }
    ,
    PreventGraphicOverlap("PreventGraphicOverlap", "Option to have text flowing around graphics.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EX_PREVENTGRAPHICOVERLAP = 59;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 59, (Boolean)object);
        }
    }
    ,
    PageBreakLimit("PageBreakLimit", "This option sets a suggested page size for the output generated. PageSize is in characters", (Object)0L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.HTMLEXPORT), null, (Class)Long.class){
        private final int SCCOPT_EX_PAGESIZE = 50;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 50, (Long)object);
        }
    }
    ,
    WebViewStructure("WebViewStructure", " This is an option that enables \"Ajax mode\" in web view output files. Enabling Ajax mode directly affects the structure of the output files created by Web View Export._PARA_ - When this option is TRUE, the output files that comprise the web view of a document will use Ajax techniques to load portions of the web view on demand, in response to browser-based requests. This generally means that the export process will produce a higher number of smaller output files._PARA_ - When this option is FALSE, the entire document will be exported in a single operation to fewer, larger output files._PARA_ There are other practical differences implied by Ajax mode._PARA_ When Ajax mode is enabled:_PARA_ - HTML content is spread among multiple output pages._PARA_ - Document internal data is exported in JSON format, and stored in multiple output files._PARA_ - The browser may begin viewing the document before the entire output has been produced._PARA_ - Documents produced in Ajax mode can be embedded into another page with the OIT.view.load Javascript API method._PARA_ - Documents produced in Ajax mode generally cannot be opened by a browser directly from the local file system (e.g., from a file:/// URL.) This is due to security features that restrict most browsers to using Ajax loading methods only on files accessed from web servers._PARA_ When Ajax mode is disabled:_PARA_ - HTML content is exported in a single HTML file._PARA_ - Document internal data is exported in a single Javascript file._PARA_ - The web view output may not be viewed until the entire export operation is complete._PARA_ - Documents produced without Ajax mode enabled may not be loaded via OIT.view.load._PARA_ - Documents produced without Ajax mode enabled may be opened by a browser directly from the local file system (possibly with a security warning regarding Javascript.)", (Object)((Object)WebViewStructureValue.FLAT), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)WebViewStructureValue.class){
        private final int SCCOPT_OUTPUT_STRUCTURE = 286144;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286144, ((WebViewStructureValue)((Object)object)).value);
        }
    }
    ,
    URLPathResources("URLPathResources", "option for specifying the base url for Web View scripts, css files and other resources that do not vary with the converted file.", (Object)null, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)String.class){
        private final int SCCOPT_URLPATH_RESOURCES = 286145;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286145, (String)object);
        }
    }
    ,
    URLPathOutput("URLPathOutput", "option for specifying the base url for output files generated during the export process.", (Object)null, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)String.class){
        private final int SCCOPT_URLPATH_OUTPUT = 286146;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286146, (String)object);
        }
    }
    ,
    ExternalStylesheets("ExternalStylesheets", "option for specifying the url of a user supplied stylesheet to be included in the output html file.", (Object)null, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)List.class, new Class[]{String.class}){
        private final int SCCOPT_EXTERNAL_STYLESHEET = 286154;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            List list = (List)object;
            for (String string : list) {
                oILink.DASetOption(oIHandle, 286154, string);
            }
        }
    }
    ,
    PostLibraryScripts("PostLibraryScripts", "option specifying the relative url of the customer's initialization script.", (Object)null, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)List.class, new Class[]{String.class}){
        private final int SCCOPT_POST_LIBRARY_SCRIPT = 286147;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            List list = (List)object;
            for (String string : list) {
                oILink.DASetOption(oIHandle, 286147, string);
            }
        }
    }
    ,
    PreLibraryScripts("PreLibraryScripts", "option specifying the url of a script file to be referenced via a <script> tag in the output file.", (Object)null, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)List.class, new Class[]{String.class}){
        private final int SCCOPT_PRE_LIBRARY_SCRIPT = 286148;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            List list = (List)object;
            for (String string : list) {
                oILink.DASetOption(oIHandle, 286148, string);
            }
        }
    }
    ,
    OutputRawtext("OutputRawtext", "option to control whether raw text output is generated on the server side", (Object)true, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_OUTPUT_RAWTEXT = 286149;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286149, (Boolean)object);
        }
    }
    ,
    FontBaseURL("FontBaseURL", "option to specify the base url used in the Web View output when referencing a exported font as a downloadable font.", (Object)null, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)String.class){
        private final int SCCOPT_FONT_BASE_URL = 286151;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286151, (String)object);
        }
    }
    ,
    WebFontPermissions("WebFontPermissions", "option that describes how fonts are embedded", (Object)EnumSet.of(WebFontPermissionValues.DEFAULTPERMISSIONS), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)EnumSet.class, new Class[]{WebFontPermissionValues.class}){
        private final int SCCOPT_FONT_PERMISSIONS_MODE = 286150;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            long l = 0L;
            for (WebFontPermissionValues webFontPermissionValues : (EnumSet)object) {
                l |= webFontPermissionValues.value;
            }
            oILink.DASetOption(oIHandle, 286150, l);
        }
    }
    ,
    FontReferenceMethod("FontReferenceMethod", "option that controls the way fonts are presented (or not) in the HTML5 output.", (Object)((Object)FontReferenceMethodValue.REFERENCEBYNAME), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)FontReferenceMethodValue.class){
        private final int SCCOPT_FONT_REFERENCE_METHOD = 286152;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286152, ((FontReferenceMethodValue)((Object)object)).value);
        }
    }
    ,
    EmailAttachmentHandling("EmailAttachmentHandling", "option that controls the way EMail Attachments are handled.", (Object)((Object)EmailAttachmentHandlingValue.NONE), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)EmailAttachmentHandlingValue.class){
        private final int SCCOPT_EMAIL_ATTACHMENT_HANDLING = 286153;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286153, ((EmailAttachmentHandlingValue)((Object)object)).value);
        }
    }
    ,
    WebViewStylesheetName("WebViewStylesheetName", "String option specifying the file name of the Web View stylesheet", (Object)"oit.css", OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)String.class){
        private final int SCCOPT_WV_STYLESHEET_NAME = 286157;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286157, (String)object);
        }
    }
    ,
    WebViewLibraryName("WebViewLibraryName", "String option specifying the file name of the Web View Javascript library", (Object)"oit.js", OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)String.class){
        private final int SCCOPT_WV_LIBRARY_NAME = 286158;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286158, (String)object);
        }
    }
    ,
    RawTextBufferSize("RawTextBufferSize", "Raw text buffer size", (Object)65536L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)Long.class){
        private final int SCCOPT_EX_TEXTBUFFERSIZE = 37;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 37, (Long)object);
        }
    }
    ,
    VectorObjectLimit("VectorObjectLimit", "Limit of the number of SVG vector objects that will be generated in a drawing", (Object)5000L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)Long.class){
        private final int SCCOPT_VECTOROBJECTLIMIT = 286167;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286167, (Long)object);
        }
    }
    ,
    WrapSourceEMailFilesToFixedWidth("WrapSourceEMailFilesToFixedWidth", "option to control wrapping EMail input files to a fixed width during conversion", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_EMAIL_FIXEDWIDTH = 286168;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286168, (Boolean)object);
        }
    }
    ,
    WrapSourceHTMLFilesToFixedWidth("WrapSourceHTMLFilesToFixedWidth", "option to control wrapping HTML input files to a fixed width during conversion", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_HTML_FIXEDWIDTH = 286169;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286169, (Boolean)object);
        }
    }
    ,
    PaginatePlainTextFiles("PaginatePlainTextFiles", "option to control formatting plain text files as paginated content", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_PLAINTEXT_PAGINATION = 286170;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286170, (Boolean)object);
        }
    }
    ,
    WebviewJSONPageCount("WebviewJSONPageCount", "option to specify maximum number of pages to write to each JSON output file", (Object)5L, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)Long.class){
        private final int SCCOPT_PAGES_PER_FILE = 286171;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286171, (Long)object);
        }
    }
    ,
    TrackAnnotations("TrackAnnotations", "option that describes which annotations need to be tracked in the manifest file", (Object)EnumSet.of(TrackAnnotationsValues.ALL), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT), null, (Class)EnumSet.class, new Class[]{TrackAnnotationsValues.class}){
        private final int SCCOPT_TRACK_ANNOTATIONS = 286244;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            long l = 0L;
            for (TrackAnnotationsValues trackAnnotationsValues : (EnumSet)object) {
                l |= trackAnnotationsValues.value;
            }
            oILink.DASetOption(oIHandle, 286244, l);
        }
    }
    ,
    FlagPageRedactionsEnabled("FlagPageRedactionsEnabled", "option to flag pages having redaction applied.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_FLAG_PAGEREDACTIONS_ENABLE = 286245;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286245, (Boolean)object);
        }
    }
    ,
    RedactionColor("RedactionColor", "Redaction Rectangles Color", (Object)new ColorInfo(0, 0, 0), OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)ColorInfo.class){
        private final int SCCOPT_REDACTION_COLOR = 286159;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286159, ((ColorInfo)object).getOptionValue());
        }
    }
    ,
    RedactionLabelsVisible("RedactionLabelsVisible", "option to render redaction labels in output", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_SHOW_REDACTION_LABELS = 286163;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286163, (Boolean)object);
        }
    }
    ,
    RedactionLabelFont("RedactionLabelFont", "Name and size of font to use for redaction labels", null, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.RedactionLabelFontOption, FontInfo.class),
    RedactionsEnabled("RedactionsEnabled", "option to inform the export to format the output to be redaction-capable.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_REDACTIONS_ENABLED = 286162;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286162, (Boolean)object);
        }
    }
    ,
    PrintTitleDisabled("PrintTitleDisabled", "option to disable print title in the output file.", (Object)false, OptionImpl.OptionScopeValue.OUTPUT, (EnumSet)EnumSet.of(Option.OutsideInProducts.WEBVIEWEXPORT, Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), null, (Class)Boolean.class, null){
        private final int SCCOPT_PRINT_TITLE_DISABLE = 286246;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 286246, (Boolean)object);
        }
    }
    ,
    MarginTextFont("MarginTextFont", "Name and size of font to use for endorsement text", new FontInfo("Arial", 18), OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.MargintextFontOption, FontInfo.class),
    MarginText("MarginText", "The Margin text to add", null, OptionImpl.OptionScopeValue.OUTPUT, EnumSet.of(Option.OutsideInProducts.PDFEXPORT, Option.OutsideInProducts.IMAGEEXPORT), SpecialOptionFlag.MargintextOption, MarginText.class),
    TimeZoneText("TimeZoneText", "Option to specify the time zone Text to display times in", (Object)null, OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)String.class){
        private final int SCCOPT_TIMEZONETEXT = 338692;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338692, (String)object);
        }
    }
    ,
    HiddenTextFlag("HiddenTextFlag", "Option to specify the Hidden Text flag to disable Transparent Text", (Object)false, OptionImpl.OptionScopeValue.GLOBAL, (EnumSet)EnumSet.allOf(Option.OutsideInProducts.class), null, (Class)Boolean.TYPE){
        private final int SCCOPT_HIDDENTEXTFLAG = 338504;

        @Override
        void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
            oILink.DASetOption(oIHandle, 338504, (Boolean)object);
        }
    };

    private final String name;
    private final String description;
    private final Object defaultValue;
    private final OptionImpl.OptionScopeValue scope;
    private final EnumSet<Option.OutsideInProducts> m_products;
    private final SpecialOptionFlag m_specialOptionFlag;
    private final Class<?> m_type;
    private final Class<?>[] m_subTypes;
    static final int SCCOPT_EX_GRIDROWS = 55;
    static final int SCCOPT_EX_GRIDCOLS = 56;
    static final int SCCOPT_EX_GRIDADVANCE = 57;
    static final int SCCOPT_EX_GRIDWRAP = 58;
    static final int SCCOPT_XML_DEF_METHOD = 61;
    static final int SCCOPT_XML_DEF_REFERENCE = 62;
    static final int SCCOPT_TIFFOPTIONS = 84;
    static final int SCCOPT_EXXML_DEF_METHOD = 91;
    static final int SCCOPT_EXXML_DEF_REFERENCE = 92;
    static final int SCCOPT_GRAPHIC_WATERMARK_OPACITY = 113;
    static final int SCCOPT_GRAPHIC_WATERMARK_SCALETYPE = 115;
    static final int SCCOPT_GRAPHIC_WATERMARK_SCALEPERCENT = 116;
    static final int SCCOPT_GRAPHIC_WATERMARK_PATH = 121;
    static final int SCCOPT_GRAPHIC_WATERMARK_HORIZONTAL_OFFSET = 123;
    static final int SCCOPT_GRAPHIC_WATERMARK_VERTICAL_OFFSET = 124;
    static final int SCCOPT_GRAPHIC_WATERMARK_HORIZONTAL_OFFSETFROM = 125;
    static final int SCCOPT_GRAPHIC_WATERMARK_VERTICAL_OFFSETFROM = 126;
    static final int SCCOPT_DEFAULTPAGESIZE = 87539;
    static final int SCCOPT_FONTDIRECTORY = 87540;
    static final int SCCOPT_EMBEDFONTS = 87542;
    static final int SCCOPT_FONTEMBEDPOLICY = 87548;
    static final int SCCOPT_DEFAULTPRINTMARGINS = 337782;
    static final int SCCOPT_DEFAULTPRINTFONT = 337783;
    static final int SCCOPT_WHATTOPRINT = 337788;
    static final int SCCOPT_PRINTSTARTPAGE = 337789;
    static final int SCCOPT_PRINTENDPAGE = 337790;
    static final int SCCOPT_PRINTFONTALIAS = 337797;
    static final int SCCOPT_FONTFILTER = 337799;
    static final int SCCOPT_WPEMAILHEADEROUTPUT = 337892;
    static final int SCCOPT_MAILHEADERVISIBLE = 337893;
    static final int SCCOPT_MAILHEADERHIDDEN = 337894;
    static final int SCCOPT_FORMATFLAGS = 273264;
    static final int SCCID_SSPRINTGRIDLINES = 338182;
    static final int SCCOPT_SSPRINTHEADINGS = 338183;
    static final int SCCOPT_SSPRINTFITTOPAGE = 338188;
    static final int SCCID_DBPRINTGRIDLINES = 338282;
    static final int SCCOPT_DBPRINTHEADINGS = 338283;
    static final int SCCOPT_DBPRINTFITTOPAGE = 338287;
    static final int SCCIDTYPE_OPTION = 262144;
    static final int SCCOPT_REDACTION_LABEL_FONT_NAME = 286160;
    static final int SCCOPT_REDACTION_LABEL_FONT_SIZE = 286161;
    static final int SCCID_MARGIN_TEXT_FONT_NAME = 286164;
    static final int SCCID_MARGIN_TEXT_FONT_SIZE = 286165;
    static final int SCCID_MARGIN_TEXT_LINE = 286166;

    private Options(String string2, String string3, Object object, OptionImpl.OptionScopeValue optionScopeValue, EnumSet<Option.OutsideInProducts> enumSet, SpecialOptionFlag specialOptionFlag, Class<?> clazz, Class<?>[] classArray) {
        this.name = string2;
        this.description = string3;
        this.defaultValue = object;
        this.scope = optionScopeValue;
        this.m_products = enumSet;
        this.m_specialOptionFlag = specialOptionFlag;
        this.m_type = clazz;
        this.m_subTypes = null == classArray ? null : classArray;
    }

    private Options(String string2, String string3, Object object, OptionImpl.OptionScopeValue optionScopeValue, EnumSet<Option.OutsideInProducts> enumSet, SpecialOptionFlag specialOptionFlag, Class<?> clazz) {
        this(string2, string3, object, optionScopeValue, enumSet, specialOptionFlag, clazz, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getDefault() {
        return this.defaultValue;
    }

    @Override
    public OptionImpl.OptionScopeValue getOptionScope() {
        return this.scope;
    }

    @Override
    public EnumSet<Option.OutsideInProducts> getSupportingProducts() {
        return this.m_products;
    }

    SpecialOptionFlag getSpecialOptionFlag() {
        return this.m_specialOptionFlag;
    }

    @Override
    public Class<?> getDataType() {
        return this.m_type;
    }

    @Override
    public Class<?>[] getItemTypes() {
        return this.m_subTypes;
    }

    void setOption(OILink oILink, OIHandle oIHandle, Object object) throws IOException {
    }

    @Override
    public void set(OptionsCache optionsCache, Object object) throws OutsideInException {
        Object object2;
        Object object3;
        block7: {
            object3 = null;
            try {
                if (this.m_type.isAssignableFrom(object.getClass())) {
                    object3 = object;
                    break block7;
                }
                if (this.m_type.equals(String.class)) {
                    object3 = object.toString();
                    break block7;
                }
                if (!Number.class.isAssignableFrom(object.getClass())) {
                    throw new Exception("Incorrect data");
                }
                object2 = (Number)Number.class.cast(object);
                if (this.m_type.equals(Integer.class)) {
                    object3 = ((Number)object2).intValue();
                    break block7;
                }
                if (this.m_type.equals(Long.class)) {
                    object3 = ((Number)object2).longValue();
                    break block7;
                }
                throw new Exception("Incorrect data");
            }
            catch (Exception exception) {
                throw new OutsideInException("Option Type mismatch - Expected object of type " + this.m_type + " but received an object of type " + object.getClass());
            }
        }
        object2 = (OptionsCacheImpl)optionsCache;
        ((OptionsCacheImpl)object2).addOptionToCache(this, object3);
    }

    @Override
    public Object get(OptionsCache optionsCache) throws OutsideInException {
        OptionsCacheImpl optionsCacheImpl = (OptionsCacheImpl)optionsCache;
        return optionsCacheImpl.getOptionFromCache(this);
    }

    public static enum SpecialOptionFlag {
        None,
        CallbackOption,
        OpenForNonSequentialAccessOption,
        PasswordsOption,
        LotusNotesIdOption,
        ExportTimeoutOption,
        DocumentOperationTimeoutOption,
        ProcessCreationTimeoutOption,
        KeyValuePairsOption,
        TiffOptions,
        DefaultPageSizeOption,
        DefaultPrintMarginOption,
        DefaultPrintFontOption,
        FontAliasOption,
        FontFilterOption,
        FontDirectoriesOption,
        MailHeadersOption,
        WatermarkOption,
        PrintRangeOption,
        FormatFlagsOption,
        GridWrapOption,
        PrintFitModeOption,
        RenderGridlineOption,
        RenderHeadingsOption,
        XMLReferenceOption,
        EmbedFontsOption,
        RedactionLabelFontOption,
        MargintextFontOption,
        MargintextOption;

    }

    public static enum TrackAnnotationsValues {
        NONE(0L),
        REDACTIONS(1L),
        HIGHLIGHTS(2L),
        ALL(255L);

        public final long value;

        private TrackAnnotationsValues(long l) {
            this.value = l;
        }
    }

    public static enum EmailAttachmentHandlingValue {
        NONE(0L),
        EXPORT(1L),
        EXPORTRECURSIVE(2L),
        EXTRACT(4L);

        public final long value;

        private EmailAttachmentHandlingValue(long l) {
            this.value = l;
        }
    }

    public static enum FontReferenceMethodValue {
        REFERENCEBYNAME(1L),
        REFERENCEEXPORTED(2L),
        REFERENCEBYBASEURL(4L);

        public final long value;

        private FontReferenceMethodValue(long l) {
            this.value = l;
        }
    }

    public static enum WebFontPermissionValues {
        DEFAULTPERMISSIONS(65536L),
        REQUIREINSTALLABLE(131072L),
        REQUIREPREVIEWPRINT(262144L),
        REQUIREEDITABLE(524288L);

        public final long value;

        private WebFontPermissionValues(long l) {
            this.value = l;
        }
    }

    public static enum WebViewStructureValue {
        FLAT(0L),
        AJAXCHUNKED(1L),
        AJAXSTREAMED(2L),
        PAGESTREAMING(3L);

        public final long value;

        private WebViewStructureValue(long l) {
            this.value = l;
        }
    }

    public static enum SuppressFontAttributeValues {
        SUPPRESSSIZE(1L),
        SUPPRESSCOLOR(2L),
        SUPPRESSFACE(4L);

        public final long value;

        private SuppressFontAttributeValues(long l) {
            this.value = l;
        }
    }

    public static enum UnmappedTextValue {
        ONLYUNMAPPED(1L),
        NOUNMAPPEDTEXT(0L),
        BOTH(2L);

        public final long value;

        private UnmappedTextValue(long l) {
            this.value = l;
        }
    }

    public static enum SearchMLParaAttributeValues {
        PARAGRAPHSPACING(65536L),
        CHARACTERHEIGHT(131072L),
        LEFTINDENT(262144L),
        RIGHTINDENT(524288L),
        FIRSTINDENT(0x100000L);

        public final long value;

        private SearchMLParaAttributeValues(long l) {
            this.value = l;
        }
    }

    public static enum SearchMLFlagValues {
        SHOWPARAGRAPHSTYLENAMES(1L),
        INCLUDECHARSTYLENAMEREFERENCES(2L),
        PROCESSEMBEDDINGS(4L),
        NOXMLDECLARATION(8L),
        TEXTCOOKIES(16L),
        SUPPRESSPROPERTIES(32L),
        GENERATETEXT(64L),
        SUPPRESSATTACHMENTS(128L),
        SUPPRESSARCHIVESUBDOCS(256L),
        METADATAONLY(512L),
        ANNOTATIONS(1024L),
        PRODUCEURLS(2048L),
        PRODUCEOBJECTINFO(4096L),
        ENABLEERRORINFO(8192L),
        PRODUCECELLINFO(16384L),
        OUTPUTSSFORMULAINFO(32768L),
        GENERATESYSTEMMETADATA(65536L),
        SKIPSTYLES(131072L),
        PRODUCEHIDDENCELLS(262144L);

        public final long value;

        private SearchMLFlagValues(long l) {
            this.value = l;
        }
    }

    public static enum IncludeCharacterAttributeValues {
        REVISIONDELETE(65536L),
        BOLD(131072L),
        ITALIC(262144L),
        UNDERLINE(524288L),
        DOUBLEUNDERLINE(0x100000L),
        OUTLINE(0x200000L),
        HIDDEN(0x400000L),
        STRIKEOUT(0x800000L),
        SMALLCAPS(0x1000000L),
        ALLCAPS(0x2000000L),
        OCE(0x4000000L),
        REVISIONADD(0x10000000L);

        public final long value;

        private IncludeCharacterAttributeValues(long l) {
            this.value = l;
        }
    }

    public static enum PageMLFlagValues {
        NOXMLDECLARATION(8L),
        INCLUDETEXT(1L);

        public final long value;

        private PageMLFlagValues(long l) {
            this.value = l;
        }
    }

    public static enum XXFormatOptionValues {
        DELIMITERS(32768L),
        OPTIMIZESECTIONS(65536L),
        FLATTENSTYLES(512L),
        PROCESSARCHIVESUBDOCUMENTS(0x100000L),
        PROCESSATTACHMENTSUBDOCUMENTS(0x400000L),
        PROCESSEMBEDDINGSUBDOCUMENTS(0x200000L),
        REMOVEFONTGROUPS(2048L),
        INCLUDETEXTOFFSETS(4096L),
        SEPARATESTYLETABLES(16384L),
        USEFULLFILEPATHS(8192L),
        BITMAPASBITMAP(1L),
        CHARTASBITMAP(2L),
        PRESENTATIONASBITMAP(4L),
        VECTORASBITMAP(8L),
        GENERATESYSTEMMETADATA(524288L),
        NOBITMAPELEMENTS(16L),
        NOCHARTELEMENTS(32L),
        NOPRESENTATIONELEMENTS(64L),
        NOVECTORELEMENTS(128L),
        DEFAULTCHARACTERMAPPING(0L),
        NOCHARACTERMAPPING(131072L),
        MAPTEXT(262144L),
        MAPPEDANDUNMAPPEDCHARACTERS(393216L),
        ISODATES(256L);

        public final long value;

        private XXFormatOptionValues(long l) {
            this.value = l;
        }
    }

    private static enum EnableSubObjectsValue {
        ENABLEALLSUBOBJECTS(0L),
        NORMALSUBOBJECTS(32L);

        public final long value;

        private EnableSubObjectsValue(long l) {
            this.value = l;
        }
    }

    public static enum ExportPerformanceModeValue {
        NORMAL(0L),
        TEXTONLY(1L),
        TEXTANDFONTS(2L);

        public final long value;

        private ExportPerformanceModeValue(long l) {
            this.value = l;
        }
    }

    public static enum DocumentMemoryModeValue {
        SMALLEST(1L),
        SMALL(2L),
        MEDIUM(3L),
        LARGE(4L),
        LARGEST(5L);

        public final long value;

        private DocumentMemoryModeValue(long l) {
            this.value = l;
        }
    }

    public static enum EmbedFontsValue {
        REDUCESIZE(0L),
        ALL(1L),
        NONE(2L);

        public final long value;

        private EmbedFontsValue(long l) {
            this.value = l;
        }
    }

    public static enum BorderModeValue {
        CREATEIFMISSING(0L),
        OFF(1L),
        USESOURCE(2L);

        public final long value;

        private BorderModeValue(long l) {
            this.value = l;
        }
    }

    public static enum PageDirectionValue {
        ACROSS(0L),
        DOWN(1L);

        public final long value;

        private PageDirectionValue(long l) {
            this.value = l;
        }
    }

    public static enum PageFitModeValue {
        NOMAP(0L),
        FITTOPAGES(5L),
        FITTOWIDTH(2L),
        FITTOHEIGHT(3L),
        SCALETOPERCENT(4L);

        public final long value;

        private PageFitModeValue(long l) {
            this.value = l;
        }
    }

    public static enum OutputGraphicTypeValue {
        GIF(1503L),
        JPEG(1535L),
        PNG(1574L),
        NONE(1998L);

        public final long value;

        private OutputGraphicTypeValue(long l) {
            this.value = l;
        }
    }

    public static enum TIFFFillOrderValue {
        FILESTORE(1L),
        TRANSMISSION(2L);

        public final long value;

        private TIFFFillOrderValue(long l) {
            this.value = l;
        }
    }

    public static enum TIFFByteOrderValue {
        LITTLEENDIAN(0L),
        BIGENDIAN(1L);

        public final long value;

        private TIFFByteOrderValue(long l) {
            this.value = l;
        }
    }

    public static enum TIFFCompressionValue {
        NONE(1L),
        PACKBITS(2L),
        LZW(3L),
        CCITT1D(4L),
        CCITTGROUP3(5L),
        CCITTGROUP4(6L);

        public final long value;

        private TIFFCompressionValue(long l) {
            this.value = l;
        }
    }

    public static enum TIFFColorSpaceValue {
        BLACKWHITE(1L),
        GRAYSCALE8BIT(4L),
        PALETTE8BIT(2L),
        RGB24BIT(3L);

        public final long value;

        private TIFFColorSpaceValue(long l) {
            this.value = l;
        }
    }

    public static enum GraphicSizeMethodValue {
        QUICKSIZING(0L),
        SMOOTHSIZING(1L),
        SMOOTHGRAYSCALESIZING(2L);

        public final long value;

        private GraphicSizeMethodValue(long l) {
            this.value = l;
        }
    }

    private static enum CropToContentValue {
        NOCROPPING(-1L),
        CROPTOCONTENT(0L);

        public final long value;

        private CropToContentValue(long l) {
            this.value = l;
        }
    }

    public static enum ProcessOLEEmbeddingModeValue {
        STANDARD(0),
        ALL(1),
        NONE(2);

        public final int value;

        private ProcessOLEEmbeddingModeValue(int n2) {
            this.value = n2;
        }
    }

    public static enum IECondCommentFlagValues {
        NONE(0L),
        IE5(1L),
        IE6(2L),
        IE7(4L),
        IE8(8L),
        IE9(16L),
        ALL(65535L);

        public final long value;

        private IECondCommentFlagValues(long l) {
            this.value = l;
        }
    }

    public static enum PDFBiDiDetectValue {
        DETECT(true),
        STANDARD(false);

        public final boolean value;

        private PDFBiDiDetectValue(boolean bl) {
            this.value = bl;
        }
    }

    public static enum BiDiReorderMethodValue {
        UNICODEOFF(0L),
        UNICODELTOR(2L),
        UNICODERTOL(3L);

        public final long value;

        private BiDiReorderMethodValue(long l) {
            this.value = l;
        }
    }

    public static enum PDFReorderBiDiValue {
        STANDARDBIDI(0L),
        REORDEREDBIDI(1L);

        public final long value;

        private PDFReorderBiDiValue(long l) {
            this.value = l;
        }
    }

    private static enum PerformExtendedFIValue {
        FINORMAL(0L),
        FIEXTENDEDTEST(1L);

        public final long value;

        private PerformExtendedFIValue(long l) {
            this.value = l;
        }
    }

    public static enum FallbackFormatValue {
        TEXT(1170L),
        NONE(1998L);

        public final long value;

        private FallbackFormatValue(long l) {
            this.value = l;
        }
    }

    public static enum HTMLFlavorValue {
        GENERICHTML(20L),
        HTML20(21L),
        HTML30(22L),
        HTML40(23L),
        NS30(28L),
        NS40(29L),
        MS30(33L),
        MS40(34L);

        public final long value;

        private HTMLFlavorValue(long l) {
            this.value = l;
        }
    }

    public static enum ExtractEmbeddedFilesValue {
        OFF(1L),
        CONVERT(2L),
        BINARY(3L);

        public final long value;

        private ExtractEmbeddedFilesValue(long l) {
            this.value = l;
        }
    }

    public static enum OutputCharacterSetValue {
        DOS437(297074944L),
        DOS737(316735744L),
        DOS850(324141312L),
        DOS852(324272384L),
        DOS855(324468992L),
        DOS857(324600064L),
        DOS860(324796672L),
        DOS863(324993280L),
        DOS865(325124352L),
        DOS866(325189888L),
        DOS869(325386496L),
        WINDOWS874(325714176L),
        WINDOWS932(329515008L),
        WINDOWS936(329777152L),
        WINDOWS949(330629120L),
        WINDOWS950(330694656L),
        WINDOWS1250(350355712L),
        WINDOWS1251(350421248L),
        WINDOWS1252(350486784L),
        WINDOWS1253(350552320L),
        WINDOWS1254(350617856L),
        WINDOWS1255(350683392L),
        WINDOWS1256(350748928L),
        WINDOWS1257(350814464L),
        UNICODE(347078656L),
        UTF8(720907L),
        ISO8859_1(524545L),
        ISO8859_2(524546L),
        ISO8859_3(524547L),
        ISO8859_4(524548L),
        ISO8859_5(524549L),
        ISO8859_6(524550L),
        ISO8859_7(524551L),
        ISO8859_8(524552L),
        ISO8859_9(524553L);

        public final long value;

        private OutputCharacterSetValue(long l) {
            this.value = l;
        }
    }

    public static enum UnicodeByteOrderValue {
        BIGENDIAN(1L),
        LITTLEENDIAN(2L),
        FROMTEMPLATE(0L);

        public final long value;

        private UnicodeByteOrderValue(long l) {
            this.value = l;
        }
    }

    public static enum DefaultInputCharacterSetValue {
        SYSTEMDEFAULT(0L),
        UNICODE(347078656L),
        BIGENDIANUNICODE(347078657L),
        LITTLEENDIANUNICODE(347078658L),
        UTF8(720907L),
        UTF7(720908L),
        ASCII(0x10000100L),
        UNIXJAPANESE(0xF0C0000L),
        UNIXJAPANESEEUC(0xF0D0000L),
        UNIXCHINESETRAD1(0xF030000L),
        UNIXCHINESEEUCTRAD1(0xF070000L),
        UNIXCHINESETRAD2(0xF040000L),
        UNIXCHINESEEUCTRAD2(0xF080000L),
        UNIXKOREAN(0xF060000L),
        UNIXCHINESESIMPLE(0xF050000L),
        EBCDIC37(1076166912L),
        EBCDIC273(0x41110100L),
        EBCDIC274(1091698944L),
        EBCDIC277(1091895552L),
        EBCDIC278(1091961088L),
        EBCDIC280(1092092160L),
        EBCDIC282(1092223232L),
        EBCDIC284(1092354304L),
        EBCDIC285(1092419840L),
        EBCDIC297(1093206272L),
        EBCDIC500(1106510080L),
        EBCDIC1026(1140982016L),
        DOS437(297074944L),
        DOS737(316735744L),
        DOS850(324141312L),
        DOS852(324272384L),
        DOS855(324468992L),
        DOS857(324600064L),
        DOS860(324796672L),
        DOS861(324862208L),
        DOS863(324993280L),
        DOS865(325124352L),
        DOS866(325189888L),
        DOS869(325386496L),
        WINDOWS874(325714176L),
        WINDOWS932(329515008L),
        WINDOWS936(329777152L),
        WINDOWS949(330629120L),
        WINDOWS950(330694656L),
        WINDOWS1250(350355712L),
        WINDOWS1251(350421248L),
        WINDOWS1252(350486784L),
        WINDOWS1253(350552320L),
        WINDOWS1254(350617856L),
        WINDOWS1255(350683392L),
        WINDOWS1256(350748928L),
        WINDOWS1257(350814464L),
        ISO8859_1(524545L),
        ISO8859_2(524546L),
        ISO8859_3(524547L),
        ISO8859_4(524548L),
        ISO8859_5(524549L),
        ISO8859_6(524550L),
        ISO8859_7(524551L),
        ISO8859_8(524552L),
        ISO8859_9(524553L),
        MACROMAN(-2147483392L),
        MACCROATIAN(-2147417856L),
        MACROMANIAN(-2147352320L),
        MACTURKISH(-2147286784L),
        MACICELANDIC(-2147221248L),
        MACCYRILLIC(-2147155712L),
        MACGREEK(-2147090176L),
        MACCE(-2147024640L),
        MACHEBREW(-2146893568L),
        MACARABIC(-2146828032L),
        MACJAPANESE(-2146762752L),
        HPROMAN8(538575104L),
        BIDIOLDCODE(786689L),
        BIDIPC8(786690L),
        BIDIE0(786691L),
        RUSSIANKOI8(655617L),
        JAPANESEX0201(655618L);

        public final long value;

        private DefaultInputCharacterSetValue(long l) {
            this.value = l;
        }
    }
}

