/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.outsidein;

import java.util.EnumSet;
import net.bitform.oilink.OILinkMessages;

public class ExportStatus {
    private EnumSet<ExportStatusFlags> m_StatusFlags = EnumSet.of(ExportStatusFlags.NOINFORMATIONAVAILABLE);
    private long m_nSubDocsPassed = -1L;
    private long m_nSubDocsFailed = -1L;
    private long m_nPageCount = 0L;

    public EnumSet<ExportStatusFlags> getStatusFlags() {
        return this.m_StatusFlags;
    }

    public long getSubDocsPassed() {
        return this.m_nSubDocsPassed;
    }

    public long getSubDocsFailed() {
        return this.m_nSubDocsFailed;
    }

    public long getPageCount() {
        return this.m_nPageCount;
    }

    ExportStatus(OILinkMessages.EXRunExportResponse eXRunExportResponse) {
        if (eXRunExportResponse.hasBStatusInfoAvailable() && eXRunExportResponse.getBStatusInfoAvailable()) {
            this.m_StatusFlags = EnumSet.noneOf(ExportStatusFlags.class);
            if (eXRunExportResponse.getBAliasedFont()) {
                this.m_StatusFlags.add(ExportStatusFlags.ALIASEDFONT);
            }
            if (eXRunExportResponse.getBEquations()) {
                this.m_StatusFlags.add(ExportStatusFlags.EQUATIONS);
            }
            if (eXRunExportResponse.getBForms()) {
                this.m_StatusFlags.add(ExportStatusFlags.FORMS);
            }
            if (eXRunExportResponse.getBMissingFont()) {
                this.m_StatusFlags.add(ExportStatusFlags.MISSINGFONT);
            }
            if (eXRunExportResponse.getBMissingMap()) {
                this.m_StatusFlags.add(ExportStatusFlags.MISSINGMAP);
            }
            if (eXRunExportResponse.getBRightToLeftTables()) {
                this.m_StatusFlags.add(ExportStatusFlags.RIGHTTOLEFTTABLES);
            }
            if (eXRunExportResponse.getBUnsupportedColorSpace()) {
                this.m_StatusFlags.add(ExportStatusFlags.UNSUPPORTEDCOLORSPACE);
            }
            if (eXRunExportResponse.getBUnsupportedCompression()) {
                this.m_StatusFlags.add(ExportStatusFlags.UNSUPPORTEDCOMPRESSION);
            }
            if (eXRunExportResponse.getBVerticalText()) {
                this.m_StatusFlags.add(ExportStatusFlags.VERTICALTEXT);
            }
            if (eXRunExportResponse.getBSubDocFailed()) {
                this.m_StatusFlags.add(ExportStatusFlags.SUBDOCFAILED);
            }
            if (eXRunExportResponse.getBTextEffects()) {
                this.m_StatusFlags.add(ExportStatusFlags.TEXTEFFECTS);
            }
            if (eXRunExportResponse.getBBidi()) {
                this.m_StatusFlags.add(ExportStatusFlags.ISBIDI);
            }
            if (eXRunExportResponse.getBUnsupportedFont()) {
                this.m_StatusFlags.add(ExportStatusFlags.UNSUPPORTEDFONT);
            }
            if (eXRunExportResponse.hasBTypeThreeFont()) {
                if (eXRunExportResponse.getBTypeThreeFont()) {
                    this.m_StatusFlags.add(ExportStatusFlags.TYPETHREEFONT);
                }
                if (eXRunExportResponse.getBUnsupportedShading()) {
                    this.m_StatusFlags.add(ExportStatusFlags.UNSUPPORTEDSHADING);
                }
                if (eXRunExportResponse.getBInvalidHTML()) {
                    this.m_StatusFlags.add(ExportStatusFlags.INVALIDHTML);
                }
                if (eXRunExportResponse.getBVectorObjectLimit()) {
                    this.m_StatusFlags.add(ExportStatusFlags.VECTOROBJECTLIMIT);
                }
                if (eXRunExportResponse.getBInvalidAnnotationNotApplied()) {
                    this.m_StatusFlags.add(ExportStatusFlags.INVALIDANNOTATIONNOTAPPLIED);
                }
            }
            if (eXRunExportResponse.hasBInlineImageFound()) {
                if (eXRunExportResponse.getBInlineImageFound()) {
                    this.m_StatusFlags.add(ExportStatusFlags.INLINEIMAGEFOUND);
                }
                if (eXRunExportResponse.getBPDFOneToMany()) {
                    this.m_StatusFlags.add(ExportStatusFlags.PDFMANYGLYPHTOONEMAPPING);
                }
            }
        }
        if (eXRunExportResponse.hasBSubDocCountsAvailable()) {
            this.m_nSubDocsFailed = eXRunExportResponse.getDwFailedSubDocs();
            this.m_nSubDocsPassed = eXRunExportResponse.getDwSucceededSubDocs();
        }
        this.m_nPageCount = eXRunExportResponse.getDwPageCount();
    }

    void addStatus(OILinkMessages.EXRunExportResponse eXRunExportResponse) {
        if (eXRunExportResponse.hasBStatusInfoAvailable() && eXRunExportResponse.getBStatusInfoAvailable()) {
            if (this.m_StatusFlags.contains((Object)ExportStatusFlags.NOINFORMATIONAVAILABLE)) {
                this.m_StatusFlags.remove((Object)ExportStatusFlags.NOINFORMATIONAVAILABLE);
            }
            if (eXRunExportResponse.getBAliasedFont()) {
                this.m_StatusFlags.add(ExportStatusFlags.ALIASEDFONT);
            }
            if (eXRunExportResponse.getBEquations()) {
                this.m_StatusFlags.add(ExportStatusFlags.EQUATIONS);
            }
            if (eXRunExportResponse.getBForms()) {
                this.m_StatusFlags.add(ExportStatusFlags.FORMS);
            }
            if (eXRunExportResponse.getBMissingFont()) {
                this.m_StatusFlags.add(ExportStatusFlags.MISSINGFONT);
            }
            if (eXRunExportResponse.getBMissingMap()) {
                this.m_StatusFlags.add(ExportStatusFlags.MISSINGMAP);
            }
            if (eXRunExportResponse.getBRightToLeftTables()) {
                this.m_StatusFlags.add(ExportStatusFlags.RIGHTTOLEFTTABLES);
            }
            if (eXRunExportResponse.getBUnsupportedColorSpace()) {
                this.m_StatusFlags.add(ExportStatusFlags.UNSUPPORTEDCOLORSPACE);
            }
            if (eXRunExportResponse.getBUnsupportedCompression()) {
                this.m_StatusFlags.add(ExportStatusFlags.UNSUPPORTEDCOMPRESSION);
            }
            if (eXRunExportResponse.getBVerticalText()) {
                this.m_StatusFlags.add(ExportStatusFlags.VERTICALTEXT);
            }
            if (eXRunExportResponse.getBSubDocFailed()) {
                this.m_StatusFlags.add(ExportStatusFlags.SUBDOCFAILED);
            }
            if (eXRunExportResponse.getBTextEffects()) {
                this.m_StatusFlags.add(ExportStatusFlags.TEXTEFFECTS);
            }
            if (eXRunExportResponse.getBBidi()) {
                this.m_StatusFlags.add(ExportStatusFlags.ISBIDI);
            }
            if (eXRunExportResponse.getBUnsupportedFont()) {
                this.m_StatusFlags.add(ExportStatusFlags.UNSUPPORTEDFONT);
            }
            if (eXRunExportResponse.hasBTypeThreeFont()) {
                if (eXRunExportResponse.getBTypeThreeFont()) {
                    this.m_StatusFlags.add(ExportStatusFlags.TYPETHREEFONT);
                }
                if (eXRunExportResponse.getBUnsupportedShading()) {
                    this.m_StatusFlags.add(ExportStatusFlags.UNSUPPORTEDSHADING);
                }
                if (eXRunExportResponse.getBInvalidHTML()) {
                    this.m_StatusFlags.add(ExportStatusFlags.INVALIDHTML);
                }
                if (eXRunExportResponse.getBVectorObjectLimit()) {
                    this.m_StatusFlags.add(ExportStatusFlags.VECTOROBJECTLIMIT);
                }
                if (eXRunExportResponse.getBInvalidAnnotationNotApplied()) {
                    this.m_StatusFlags.add(ExportStatusFlags.INVALIDANNOTATIONNOTAPPLIED);
                }
            }
            if (eXRunExportResponse.hasBInlineImageFound()) {
                if (eXRunExportResponse.getBInlineImageFound()) {
                    this.m_StatusFlags.add(ExportStatusFlags.INLINEIMAGEFOUND);
                }
                if (eXRunExportResponse.getBPDFOneToMany()) {
                    this.m_StatusFlags.add(ExportStatusFlags.PDFMANYGLYPHTOONEMAPPING);
                }
            }
        }
        if (eXRunExportResponse.hasBSubDocCountsAvailable()) {
            this.m_nSubDocsFailed += eXRunExportResponse.getDwFailedSubDocs();
            this.m_nSubDocsPassed += eXRunExportResponse.getDwSucceededSubDocs();
        }
        this.m_nPageCount += eXRunExportResponse.getDwPageCount();
    }

    public static enum ExportStatusFlags {
        NOINFORMATIONAVAILABLE,
        MISSINGMAP,
        VERTICALTEXT,
        TEXTEFFECTS,
        UNSUPPORTEDCOMPRESSION,
        UNSUPPORTEDCOLORSPACE,
        FORMS,
        RIGHTTOLEFTTABLES,
        EQUATIONS,
        ALIASEDFONT,
        MISSINGFONT,
        SUBDOCFAILED,
        TYPETHREEFONT,
        UNSUPPORTEDSHADING,
        INVALIDHTML,
        VECTOROBJECTLIMIT,
        INVALIDANNOTATIONNOTAPPLIED,
        INLINEIMAGEFOUND,
        PDFMANYGLYPHTOONEMAPPING,
        ISBIDI,
        UNSUPPORTEDFONT;

    }
}

